"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_elasticsearch_1 = require("monocdk/aws-elasticsearch");
const aws_opensearchservice_1 = require("monocdk/aws-opensearchservice");
/**
 * OpenSearch Service domains do not allow for unsigned requests or anonymous access
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticsearch_1.CfnDomain || node instanceof aws_opensearchservice_1.CfnDomain) {
        const accessPolicies = monocdk_1.Stack.of(node).resolve(node.accessPolicies);
        if (accessPolicies == undefined) {
            return false;
        }
        const statements = accessPolicies === null || accessPolicies === void 0 ? void 0 : accessPolicies.Statement;
        if (statements == undefined || statements.length == 0) {
            return false;
        }
        for (const statement of statements) {
            if (statement.Effect == 'Allow') {
                const awsString = statement.Principal
                    ? JSON.stringify(statement.Principal)
                    : '';
                if (awsString.includes('*')) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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