"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_kinesisanalytics_1 = require("monocdk/aws-kinesisanalytics");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Kinesis Data Analytics Flink Applications have checkpointing enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_kinesisanalytics_1.CfnApplicationV2) {
        if (node.runtimeEnvironment.toLowerCase().startsWith('flink')) {
            const applicationConfiguration = monocdk_1.Stack.of(node).resolve(node.applicationConfiguration);
            if (applicationConfiguration == undefined) {
                return false;
            }
            const flinkApplicationConfiguration = monocdk_1.Stack.of(node).resolve(applicationConfiguration.flinkApplicationConfiguration);
            if (flinkApplicationConfiguration == undefined) {
                return false;
            }
            const checkpointConfiguration = monocdk_1.Stack.of(node).resolve(flinkApplicationConfiguration.checkpointConfiguration);
            if (checkpointConfiguration == undefined) {
                return false;
            }
            if (nag_pack_1.resolveIfPrimitive(node, checkpointConfiguration.configurationType) ==
                'CUSTOM') {
                const enabled = nag_pack_1.resolveIfPrimitive(node, checkpointConfiguration.checkpointingEnabled);
                if (!enabled) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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