"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_athena_1 = require("monocdk/aws-athena");
const __1 = require("../../..");
/**
 * Athena workgroups encrypt query results
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_athena_1.CfnWorkGroup) {
        const workGroupConfiguration = monocdk_1.Stack.of(node).resolve(node.workGroupConfiguration);
        if (workGroupConfiguration == undefined) {
            const workGroupConfigurationUpdates = monocdk_1.Stack.of(node).resolve(node.workGroupConfigurationUpdates);
            if (workGroupConfigurationUpdates == undefined) {
                return false;
            }
            const resultConfigurationUpdates = monocdk_1.Stack.of(node).resolve(workGroupConfigurationUpdates.resultConfigurationUpdates);
            if (resultConfigurationUpdates != undefined) {
                const removeEncryptionConfiguration = __1.resolveIfPrimitive(node, resultConfigurationUpdates.removeEncryptionConfiguration);
                const encryptionConfiguration = monocdk_1.Stack.of(node).resolve(resultConfigurationUpdates.encryptionConfiguration);
                const enforceWorkGroupConfiguration = __1.resolveIfPrimitive(node, workGroupConfigurationUpdates.enforceWorkGroupConfiguration);
                if (removeEncryptionConfiguration &&
                    encryptionConfiguration == undefined) {
                    return false;
                }
                else if (encryptionConfiguration != undefined &&
                    !enforceWorkGroupConfiguration) {
                    return false;
                }
            }
        }
        else {
            const enforceWorkGroupConfiguration = __1.resolveIfPrimitive(node, workGroupConfiguration.enforceWorkGroupConfiguration);
            if (!enforceWorkGroupConfiguration) {
                return false;
            }
            const resultConfiguration = monocdk_1.Stack.of(node).resolve(workGroupConfiguration.resultConfiguration);
            if (resultConfiguration == undefined) {
                return false;
            }
            const encryptionConfiguration = monocdk_1.Stack.of(node).resolve(resultConfiguration.encryptionConfiguration);
            if (encryptionConfiguration == undefined) {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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