# generated by datamodel-codegen:
#   filename:  settings/eventPublisherJob.json
#   timestamp: 2023-03-07T15:24:13+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ..type import basic


class Status(Enum):
    STARTING = 'STARTING'
    ACTIVE = 'ACTIVE'
    RETRY = 'RETRY'
    ACTIVE_WITH_ERROR = 'ACTIVE_WITH_ERROR'
    IDLE = 'IDLE'
    COMPLETED = 'COMPLETED'


class Stats(BaseModel):
    class Config:
        extra = Extra.forbid

    success: Optional[int] = Field(0, description='Count of Success Record')
    failed: Optional[int] = Field(0, description='Count of Failed Records')
    total: Optional[int] = Field(0, description='Count of Failed Records')


class RunMode(Enum):
    stream = 'stream'
    batch = 'batch'


class PublisherType(Enum):
    elasticSearch = 'elasticSearch'
    kafka = 'kafka'


class FailureDetails(BaseModel):
    class Config:
        extra = Extra.forbid

    context: Optional[str] = Field(None, description='Additional Context for Failure.')
    lastFailedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last non-successful callback time in UNIX UTC epoch time in milliseconds.',
    )
    lastFailedReason: Optional[str] = Field(
        None,
        description='Last non-successful activity response reason received during callback.',
    )


class EventPublisherResult(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str = Field(..., description='Name of the result')
    startedBy: Optional[str] = Field(None, description='Job started by')
    publisherType: PublisherType
    runMode: RunMode
    timestamp: basic.Timestamp
    startTime: Optional[basic.Timestamp] = None
    endTime: Optional[basic.Timestamp] = None
    status: Status = Field(..., description='This schema publisher run job status.')
    failureDetails: Optional[FailureDetails] = Field(
        None, description='Failure details are set only when `status` is not `success`.'
    )
    stats: Optional[Stats] = None
    entities: Optional[List[str]] = Field(
        None, description='List of Entities to Reindex', unique_items=True
    )
