# generated by datamodel-codegen:
#   filename:  metadataIngestion/dbtPipeline.json
#   timestamp: 2023-03-07T15:24:13+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from .dbtconfig import (
    dbtCloudConfig,
    dbtGCSConfig,
    dbtHttpConfig,
    dbtLocalConfig,
    dbtS3Config,
)


class DbtConfigType(Enum):
    DBT = 'DBT'


class DbtPipeline(BaseModel):
    class Config:
        extra = Extra.forbid

    type: Optional[DbtConfigType] = Field(
        DbtConfigType.DBT, description='Pipeline type'
    )
    dbtConfigSource: Optional[
        Union[
            dbtCloudConfig.DbtCloudConfig,
            dbtLocalConfig.DbtLocalConfig,
            dbtHttpConfig.DbtHttpConfig,
            dbtS3Config.DbtS3Config,
            dbtGCSConfig.DbtGcsConfig,
        ]
    ] = Field(
        None,
        description='Available sources to fetch DBT catalog and manifest files.',
        title='DBT Configuration Source',
    )
    dbtUpdateDescriptions: Optional[bool] = Field(
        False,
        description='Optional configuration to update the description from DBT or not',
    )
    dbtClassificationName: Optional[str] = Field(
        'dbtTags',
        description='Custom OpenMetadata Classification name for dbt tags.',
        title='dbt Classification Name',
    )
