# generated by datamodel-codegen:
#   filename:  entity/events/webhook.json
#   timestamp: 2023-03-07T15:24:13+00:00

from __future__ import annotations

from typing import Optional

from pydantic import AnyUrl, BaseModel, Extra, Field, constr

from ...type import basic


class EntityName(BaseModel):
    __root__: constr(regex=r'^(?u)[\w\'\-.]+$', min_length=1, max_length=128) = Field(
        ..., description='Unique name of the application receiving webhook events.'
    )


class Webhook(BaseModel):
    class Config:
        extra = Extra.forbid

    name: EntityName
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this webhook.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the application.'
    )
    endpoint: AnyUrl = Field(
        ..., description='Endpoint to receive the webhook events over POST requests.'
    )
    secretKey: Optional[str] = Field(
        None,
        description='Secret set by the webhook client used for computing HMAC SHA256 signature of webhook payload and sent in `X-OM-Signature` header in POST requests to publish the events.',
    )
