# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ThermalCameraSettingsChild(Model):
    """ThermalCameraSettingsChild.

    :param atmosphere_temperature: The ambient temperature on the camera in
     Kelvin.
    :type atmosphere_temperature: float
    :param emissivity: The Emissivity value used in calculating temperature.
    :type emissivity: float
    :param distance:
    :type distance: float
    :param reflected_temperature: The reflected temperature of the object in
     Kelvin.
    :type reflected_temperature: float
    :param relative_humidity: The relative humidity of the camera.
    :type relative_humidity: float
    :param window_transmission_rate: The amount of thermal radiation allowed
     through an external window.
    :type window_transmission_rate: float
    :param window_temperature: The temperature of any external thermal windows
     in Kelvin.
    :type window_temperature: float
    :param update_interval: How often a value is transmitted to SD
    :type update_interval: int
    """

    _validation = {
        'emissivity': {'maximum': 1, 'minimum': 0.001},
        'relative_humidity': {'maximum': 1, 'minimum': 0},
        'window_transmission_rate': {'maximum': 1, 'minimum': 0.001},
    }

    _attribute_map = {
        'atmosphere_temperature': {'key': 'AtmosphereTemperature', 'type': 'float'},
        'emissivity': {'key': 'Emissivity', 'type': 'float'},
        'distance': {'key': 'Distance', 'type': 'float'},
        'reflected_temperature': {'key': 'ReflectedTemperature', 'type': 'float'},
        'relative_humidity': {'key': 'RelativeHumidity', 'type': 'float'},
        'window_transmission_rate': {'key': 'WindowTransmissionRate', 'type': 'float'},
        'window_temperature': {'key': 'WindowTemperature', 'type': 'float'},
        'update_interval': {'key': 'UpdateInterval', 'type': 'int'},
    }

    def __init__(self, *, atmosphere_temperature: float=None, emissivity: float=None, distance: float=None, reflected_temperature: float=None, relative_humidity: float=None, window_transmission_rate: float=None, window_temperature: float=None, update_interval: int=None, **kwargs) -> None:
        super(ThermalCameraSettingsChild, self).__init__(**kwargs)
        self.atmosphere_temperature = atmosphere_temperature
        self.emissivity = emissivity
        self.distance = distance
        self.reflected_temperature = reflected_temperature
        self.relative_humidity = relative_humidity
        self.window_transmission_rate = window_transmission_rate
        self.window_temperature = window_temperature
        self.update_interval = update_interval
