# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ThermalCameraSettingsChild(Model):
    """ThermalCameraSettingsChild.

    :param atmosphere_temperature: The ambient temperature on the camera in
     Kelvin.
    :type atmosphere_temperature: float
    :param emissivity: The Emissivity value used in calculating temperature.
    :type emissivity: float
    :param distance:
    :type distance: float
    :param reflected_temperature: The reflected temperature of the object in
     Kelvin.
    :type reflected_temperature: float
    :param relative_humidity: The relative humidity of the camera.
    :type relative_humidity: float
    :param window_transmission_rate: The amount of thermal radiation allowed
     through an external window.
    :type window_transmission_rate: float
    :param window_temperature: The temperature of any external thermal windows
     in Kelvin.
    :type window_temperature: float
    :param update_interval: How often a value is transmitted to SD
    :type update_interval: int
    """

    _validation = {
        'emissivity': {'maximum': 1, 'minimum': 0.001},
        'relative_humidity': {'maximum': 1, 'minimum': 0},
        'window_transmission_rate': {'maximum': 1, 'minimum': 0.001},
    }

    _attribute_map = {
        'atmosphere_temperature': {'key': 'AtmosphereTemperature', 'type': 'float'},
        'emissivity': {'key': 'Emissivity', 'type': 'float'},
        'distance': {'key': 'Distance', 'type': 'float'},
        'reflected_temperature': {'key': 'ReflectedTemperature', 'type': 'float'},
        'relative_humidity': {'key': 'RelativeHumidity', 'type': 'float'},
        'window_transmission_rate': {'key': 'WindowTransmissionRate', 'type': 'float'},
        'window_temperature': {'key': 'WindowTemperature', 'type': 'float'},
        'update_interval': {'key': 'UpdateInterval', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ThermalCameraSettingsChild, self).__init__(**kwargs)
        self.atmosphere_temperature = kwargs.get('atmosphere_temperature', None)
        self.emissivity = kwargs.get('emissivity', None)
        self.distance = kwargs.get('distance', None)
        self.reflected_temperature = kwargs.get('reflected_temperature', None)
        self.relative_humidity = kwargs.get('relative_humidity', None)
        self.window_transmission_rate = kwargs.get('window_transmission_rate', None)
        self.window_temperature = kwargs.get('window_temperature', None)
        self.update_interval = kwargs.get('update_interval', None)
