# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ThermalCameraRegionUpdateRequest(Model):
    """ThermalCameraRegionUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the region
    :type name: str
    :param xcoordinate: Required. The "X" coordinate that determines the
     position of the region.
     In other words, where the region is located.
    :type xcoordinate: int
    :param ycoordinate: Required. The "Y" coordinate that determines the
     position of the region.
     In other words, where the region is located.
    :type ycoordinate: int
    :param width: Required. The width of the region
    :type width: int
    :param height: Required. The height of the region
    :type height: int
    :param active: Required. Whether or not the thermal region is currently
     active
    :type active: bool
    :param instance: Required. The unique set of coordinates that designates a
     region.
     Each thermal camera can have up to 5 unique instances.
    :type instance: int
    """

    _validation = {
        'name': {'required': True, 'max_length': 50},
        'xcoordinate': {'required': True, 'maximum': 2147483647, 'minimum': 0},
        'ycoordinate': {'required': True, 'maximum': 2147483647, 'minimum': 0},
        'width': {'required': True, 'maximum': 2147483647, 'minimum': 0},
        'height': {'required': True, 'maximum': 2147483647, 'minimum': 0},
        'active': {'required': True},
        'instance': {'required': True, 'maximum': 5, 'minimum': 1},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'xcoordinate': {'key': 'XCoordinate', 'type': 'int'},
        'ycoordinate': {'key': 'YCoordinate', 'type': 'int'},
        'width': {'key': 'Width', 'type': 'int'},
        'height': {'key': 'Height', 'type': 'int'},
        'active': {'key': 'Active', 'type': 'bool'},
        'instance': {'key': 'Instance', 'type': 'int'},
    }

    def __init__(self, *, name: str, xcoordinate: int, ycoordinate: int, width: int, height: int, active: bool, instance: int, **kwargs) -> None:
        super(ThermalCameraRegionUpdateRequest, self).__init__(**kwargs)
        self.name = name
        self.xcoordinate = xcoordinate
        self.ycoordinate = ycoordinate
        self.width = width
        self.height = height
        self.active = active
        self.instance = instance
