# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ActivityEventCreateRequest(Model):
    """ActivityEventCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param location_id: Required.
    :type location_id: str
    :param category_id:
    :type category_id: int
    :param category_code:
    :type category_code: str
    :param title: Required.
    :type title: str
    :param description:
    :type description: str
    :param start_date_time:
    :type start_date_time: datetime
    :param end_date_time:
    :type end_date_time: datetime
    :param subcategories:
    :type subcategories:
     list[~smartdiagnostics_sdk.models.ActivityEventSubcategoryEntryRequest]
    :param binds:
    :type binds: list[~smartdiagnostics_sdk.models.ActivityEventBindRequest]
    :param fields:
    :type fields:
     list[~smartdiagnostics_sdk.models.ActivityEventFieldEntryRequest]
    """

    _validation = {
        'location_id': {'required': True},
        'title': {'required': True, 'max_length': 50, 'min_length': 0},
        'description': {'max_length': 1000, 'min_length': 0},
    }

    _attribute_map = {
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'category_id': {'key': 'CategoryId', 'type': 'int'},
        'category_code': {'key': 'CategoryCode', 'type': 'str'},
        'title': {'key': 'Title', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'start_date_time': {'key': 'StartDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'EndDateTime', 'type': 'iso-8601'},
        'subcategories': {'key': 'Subcategories', 'type': '[ActivityEventSubcategoryEntryRequest]'},
        'binds': {'key': 'Binds', 'type': '[ActivityEventBindRequest]'},
        'fields': {'key': 'Fields', 'type': '[ActivityEventFieldEntryRequest]'},
    }

    def __init__(self, *, location_id: str, title: str, category_id: int=None, category_code: str=None, description: str=None, start_date_time=None, end_date_time=None, subcategories=None, binds=None, fields=None, **kwargs) -> None:
        super(ActivityEventCreateRequest, self).__init__(**kwargs)
        self.location_id = location_id
        self.category_id = category_id
        self.category_code = category_code
        self.title = title
        self.description = description
        self.start_date_time = start_date_time
        self.end_date_time = end_date_time
        self.subcategories = subcategories
        self.binds = binds
        self.fields = fields
