/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.options;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.basex.core.BaseXException;
import org.basex.core.Text;
import org.basex.io.IOFile;
import org.basex.io.in.NewlineInput;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.http.MediaType;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Comment;
import org.basex.util.options.EnumOption;
import org.basex.util.options.FuncOption;
import org.basex.util.options.NumberOption;
import org.basex.util.options.NumbersOption;
import org.basex.util.options.Option;
import org.basex.util.options.OptionsOption;
import org.basex.util.options.StringOption;
import org.basex.util.options.StringsOption;
import org.basex.util.similarity.Levenshtein;

public class Options
implements Iterable<Option<?>> {
    private static final String PROPUSER = "# Local Options";
    private final TreeMap<String, Option<?>> options;
    private final TreeMap<String, Object> values;
    private final HashMap<String, String> free;
    private final StringList user = new StringList();
    private IOFile file;

    public Options() {
        this((IOFile)null);
    }

    protected Options(IOFile opts) {
        this.options = new TreeMap();
        this.values = new TreeMap();
        this.free = new HashMap();
        try {
            for (Option<?> opt : Options.options(this.getClass())) {
                if (opt instanceof Comment) continue;
                String name = opt.name();
                this.values.put(name, opt.value());
                this.options.put(name, opt);
            }
        }
        catch (Exception ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
        if (opts != null) {
            this.read(opts);
        }
    }

    protected Options(Options opts) {
        this.options = (TreeMap)opts.options.clone();
        this.values = (TreeMap)opts.values.clone();
        this.free = (HashMap)opts.free.clone();
        this.user.add(opts.user);
        this.file = opts.file;
    }

    public final synchronized void write() {
        StringList lines = new StringList();
        try {
            for (Option<?> opt : Options.options(this.getClass())) {
                String name = opt.name();
                if (opt instanceof Comment) {
                    if (!lines.isEmpty()) {
                        lines.add("");
                    }
                    lines.add("# " + name);
                    continue;
                }
                if (opt instanceof NumbersOption) {
                    int[] ints = this.get((NumbersOption)opt);
                    int is = ints == null ? 0 : ints.length;
                    for (int i = 0; i < is; ++i) {
                        lines.add(name + i + " = " + ints[i]);
                    }
                    continue;
                }
                if (opt instanceof StringsOption) {
                    String[] strings = this.get((StringsOption)opt);
                    int ss = strings == null ? 0 : strings.length;
                    lines.add(name + " = " + ss);
                    for (int s = 0; s < ss; ++s) {
                        lines.add(name + (s + 1) + " = " + strings[s]);
                    }
                    continue;
                }
                lines.add(name + " = " + this.get(opt));
            }
            ((StringList)((Object)((StringList)((Object)lines.add(""))).add(PROPUSER))).add(this.user);
            TokenBuilder tb = new TokenBuilder();
            for (String line : lines) {
                tb.add(line).add(Prop.NL);
            }
            byte[] contents = tb.finish();
            boolean skip = this.file.exists();
            if (skip) {
                TokenBuilder tmp = new TokenBuilder(contents.length);
                try (NewlineInput nli = new NewlineInput(this.file);){
                    String line;
                    while ((line = nli.readLine()) != null) {
                        tmp.add(line).add(Prop.NL);
                    }
                }
                skip = Token.eq(contents, tmp.finish());
            }
            if (!skip) {
                this.file.parent().md();
                this.file.write(contents);
            }
        }
        catch (Exception ex) {
            Util.errln("% could not be written.", this.file);
            Util.debug(ex);
        }
    }

    public final synchronized Option<?> option(String name) {
        return this.options.get(name);
    }

    public final synchronized Object get(Option<?> option) {
        return this.values.get(option.name());
    }

    public final synchronized void put(Option<?> option, Object value) {
        this.values.put(option.name(), value);
    }

    public final synchronized boolean contains(Option<?> option) {
        return this.get(option) != null;
    }

    public final synchronized String get(StringOption option) {
        return (String)this.get((Option<?>)option);
    }

    public final synchronized Integer get(NumberOption option) {
        return (Integer)this.get((Option<?>)option);
    }

    public final synchronized Boolean get(BooleanOption option) {
        return (Boolean)this.get((Option<?>)option);
    }

    public final synchronized FuncItem get(FuncOption option) {
        return (FuncItem)this.get((Option<?>)option);
    }

    public final synchronized String[] get(StringsOption option) {
        return (String[])this.get((Option<?>)option);
    }

    public final synchronized int[] get(NumbersOption option) {
        return (int[])this.get((Option<?>)option);
    }

    public final synchronized <O extends Options> O get(OptionsOption<O> option) {
        return (O)((Options)this.get((Option<?>)option));
    }

    public final synchronized <E extends Enum<E>> E get(EnumOption<E> option) {
        return (E)((Enum)this.get((Option<?>)option));
    }

    public final synchronized void set(StringOption option, String value) {
        this.put(option, value);
    }

    public final synchronized void set(NumberOption option, int value) {
        this.put(option, value);
    }

    public final synchronized void set(BooleanOption option, boolean value) {
        this.put(option, value);
    }

    public final synchronized void set(StringsOption option, String[] value) {
        this.put(option, value);
    }

    public final synchronized void set(NumbersOption option, int[] value) {
        this.put(option, value);
    }

    public final synchronized <O extends Options> void set(OptionsOption<O> option, O value) {
        this.put(option, value);
    }

    public final synchronized <V extends Enum<V>> void set(EnumOption<V> option, Enum<V> value) {
        this.put(option, value);
    }

    public final synchronized <V extends Enum<V>> void set(EnumOption<V> option, String value) {
        this.put(option, option.get(value));
    }

    public synchronized void assign(String name, String value) throws BaseXException {
        if (this.options.isEmpty()) {
            this.free.put(name, value);
        } else {
            this.assign(name, value, -1, true);
        }
    }

    public synchronized void assign(Item name, Value value, boolean error, InputInfo ii) throws BaseXException, QueryException {
        Item item;
        String nm;
        if (name instanceof QNm) {
            nm = Token.string(((QNm)name).id());
        } else if (name.type.isStringOrUntyped()) {
            nm = Token.string(name.string(ii));
        } else {
            throw new BaseXException("% expected, % found: %.", AtomType.STRING, name.type, name);
        }
        if (value.isItem()) {
            item = value instanceof QNm ? Str.get(((QNm)value).id()) : (Item)value;
        } else if (value.size() > 1L) {
            TokenBuilder tb = new TokenBuilder();
            for (Item it : value) {
                if (!tb.isEmpty()) {
                    tb.add(32);
                }
                tb.add(Options.serialize(it, ii));
            }
            item = Str.get(tb.finish());
        } else {
            throw new BaseXException("% expected, % found: %.", SeqType.ITEM_O, value.seqType(), value);
        }
        if (this.options.isEmpty()) {
            this.free.put(nm, Options.serialize(item, ii));
        } else {
            this.assign(nm, item, error, ii);
        }
    }

    private static String serialize(Item item, InputInfo ii) throws BaseXException, QueryException {
        TokenBuilder tb = new TokenBuilder();
        if (item instanceof XQMap) {
            XQMap map = (XQMap)item;
            for (Item key : map.keys()) {
                if (!tb.isEmpty()) {
                    tb.add(44);
                }
                tb.add(key.string(ii)).add(61);
                Value vl = map.get(key, ii);
                if (!vl.isItem()) {
                    throw new BaseXException("% expected, % found: %.", AtomType.STRING, vl.seqType(), vl);
                }
                tb.add(Token.string(((Item)vl).string(ii)).replace(",", ",,"));
            }
        } else if (item instanceof QNm) {
            tb.add(((QNm)item).id());
        } else {
            tb.add(item.string(ii));
        }
        return tb.toString();
    }

    public final synchronized HashMap<String, String> free() {
        return this.free;
    }

    public final Map<String, String> toMap(StringOption option) {
        return Options.toMap(this.get(option));
    }

    public static Map<String, String> toMap(String opts) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        boolean left = true;
        int sl = opts.length();
        for (int s = 0; s < sl; ++s) {
            char ch = opts.charAt(s);
            if (left) {
                if (ch == '=') {
                    left = false;
                    continue;
                }
                key.append(ch);
                continue;
            }
            if (ch == ',') {
                if (s + 1 == sl || opts.charAt(s + 1) != ',') {
                    map.put(key.toString().trim(), value.toString());
                    key.setLength(0);
                    value.setLength(0);
                    left = true;
                    continue;
                }
                ++s;
            }
            value.append(ch);
        }
        if (!left) {
            map.put(key.toString().trim(), value.toString());
        }
        return map;
    }

    public final synchronized String error(String name) {
        Object similar = Levenshtein.similar(Token.token(name), this.options.keySet().toArray(new String[0]));
        return similar != null ? Util.info(Text.UNKNOWN_OPT_SIMILAR_X_X, name, similar) : Util.info(Text.UNKNOWN_OPTION_X, name);
    }

    public final synchronized boolean invert(BooleanOption option) {
        boolean val = this.get(option) == false;
        this.set(option, val);
        return val;
    }

    public void setSystem() {
        for (Map.Entry<String, String> entry : Prop.entries()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!name.startsWith("org.basex.")) continue;
            name = name.substring("org.basex.".length()).toUpperCase(Locale.ENGLISH);
            try {
                if (!this.assign(name, value, -1, false)) continue;
                Util.debug(name + ": " + value, new Object[0]);
            }
            catch (BaseXException ex) {
                Util.errln(ex, new Object[0]);
            }
        }
    }

    public final synchronized void assign(MediaType type) throws BaseXException {
        for (Map.Entry<String, String> entry : type.parameters().entrySet()) {
            if (this.options.isEmpty()) {
                this.free.put(entry.getKey(), entry.getValue());
                continue;
            }
            this.assign(entry.getKey(), entry.getValue(), -1, false);
        }
    }

    public final synchronized void assign(String string) throws BaseXException {
        for (Map.Entry<String, String> entry : Options.toMap(string).entrySet()) {
            this.assign(entry.getKey(), entry.getValue());
        }
    }

    public final synchronized void assign(XQMap map, boolean error, InputInfo ii) throws BaseXException, QueryException {
        for (Item name : map.keys()) {
            this.assign(name, map.get(name, ii), error, ii);
        }
    }

    public final synchronized String[] names() {
        StringList sl = new StringList(this.options.size());
        for (Option<?> option : this) {
            sl.add(option.name());
        }
        return (String[])sl.finish();
    }

    @Override
    public final synchronized Iterator<Option<?>> iterator() {
        return this.options.values().iterator();
    }

    public final synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        this.values.forEach((? super K name, ? super V value) -> {
            if (value != null) {
                StringList sl = new StringList();
                Object value2 = this.options.get(name).value();
                if (value instanceof String[]) {
                    for (String s : (String[])value) {
                        sl.add(s);
                    }
                } else if (value instanceof int[]) {
                    for (Object s : (Object)((int[])value)) {
                        sl.add(Integer.toString((int)s));
                    }
                } else if (value instanceof Options) {
                    String s = value.toString();
                    if (value2 == null || !s.equals(value2.toString())) {
                        sl.add(s);
                    }
                } else if (!value.equals(value2)) {
                    sl.add(value.toString());
                }
                for (String s : sl) {
                    if (sb.length() != 0) {
                        sb.append(',');
                    }
                    sb.append((String)name).append('=').append(s.replace(",", ",,"));
                }
            }
        });
        return sb.toString();
    }

    public static String allowed(Option<?> option, String value, Object ... all) {
        TokenBuilder vals = new TokenBuilder();
        for (Object a : all) {
            if (!vals.isEmpty()) {
                vals.add(44);
            }
            vals.add(a);
        }
        return Util.info("Invalid '%' value '%'; must be one of: %.", option.name(), value, vals);
    }

    private static Option<?>[] options(Class<? extends Options> clz) throws IllegalAccessException {
        ArrayList<Option> opts = new ArrayList<Option>();
        for (Field f : clz.getFields()) {
            Object obj;
            if (!Modifier.isStatic(f.getModifiers()) || !((obj = f.get(null)) instanceof Option)) continue;
            opts.add((Option)obj);
        }
        return opts.toArray(new Option[0]);
    }

    private synchronized void read(IOFile opts) {
        this.file = opts;
        StringList read = new StringList();
        StringList errs = new StringList();
        boolean exists = this.file.exists();
        if (exists) {
            try {
                NewlineInput ni = new NewlineInput(opts);
                Object object = null;
                try {
                    String line;
                    int local = 0;
                    while ((line = ni.readLine()) != null) {
                        if ((line = line.trim()).equals(PROPUSER)) {
                            local = 1;
                            continue;
                        }
                        if (local != 0) {
                            this.user.add(line);
                        }
                        if (line.isEmpty() || line.charAt(0) == '#') continue;
                        int d = line.indexOf(61);
                        if (d < 0) {
                            errs.add("line \"" + line + "\" ignored.");
                            continue;
                        }
                        String val = line.substring(d + 1).trim();
                        String name = line.substring(0, d).trim();
                        int num = 0;
                        int ss = name.length();
                        for (int s = 0; s < ss; ++s) {
                            if (!Character.isDigit(name.charAt(s))) continue;
                            num = Strings.toInt(name.substring(s));
                            name = name.substring(0, s);
                            break;
                        }
                        if (local != 0) {
                            Prop.put("org.basex." + name.toLowerCase(Locale.ENGLISH), val);
                            continue;
                        }
                        try {
                            this.assign(name, val, num, true);
                            read.add(name);
                        }
                        catch (BaseXException ex) {
                            errs.add(ex.getMessage());
                        }
                    }
                }
                catch (Throwable local) {
                    object = local;
                    throw local;
                }
                finally {
                    if (ni != null) {
                        if (object != null) {
                            try {
                                ni.close();
                            }
                            catch (Throwable local) {
                                ((Throwable)object).addSuppressed(local);
                            }
                        } else {
                            ni.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                errs.add("file could not be parsed.");
                Util.errln(ex, new Object[0]);
            }
        }
        boolean ok = true;
        if (errs.isEmpty()) {
            try {
                for (Option<?> opt : Options.options(this.getClass())) {
                    if (!ok || opt instanceof Comment) continue;
                    ok = read.contains(opt.name());
                }
            }
            catch (IllegalAccessException ex) {
                throw Util.notExpected(ex, new Object[0]);
            }
        }
        if (!(ok && exists && errs.isEmpty())) {
            this.write();
            errs.add("writing new configuration file.");
            for (String s : errs) {
                Util.errln(this.file + ": " + s, new Object[0]);
            }
        }
    }

    private synchronized void assign(String name, Item item, boolean error, InputInfo ii) throws BaseXException, QueryException {
        Option<?> option = this.options.get(name);
        if (option == null) {
            if (error) {
                throw new BaseXException(this.error(name), new Object[0]);
            }
            return;
        }
        Object value = null;
        String expected = null;
        if (option instanceof BooleanOption) {
            if (item.type.eq(AtomType.BOOLEAN)) {
                value = item.bool(ii);
            } else {
                String s = Token.string(item.string(ii));
                Object object = Strings.toBoolean(s) ? Boolean.TRUE : (value = Strings.no(s) ? Boolean.FALSE : null);
            }
            if (value == null) {
                expected = "Invalid '%' value '%'; must be 'yes', 'no', or a boolean.";
            }
        } else if (option instanceof NumberOption) {
            value = (int)item.itr(ii);
        } else if (option instanceof StringOption) {
            value = Options.serialize(item, ii);
        } else if (option instanceof EnumOption) {
            long l;
            byte[] token = item.type.eq(AtomType.BOOLEAN) ? item.string(ii) : (item.type.isNumber() ? ((l = item.itr(ii)) == 1L ? Token.TRUE : (byte[])(l == 0L ? Token.FALSE : null)) : item.string(ii));
            if (token == null) {
                expected = "Invalid '%' value '%'; must be 'yes', 'no', or a boolean.";
            } else {
                EnumOption eo = (EnumOption)option;
                value = eo.get(Token.eq(token, Token.TRUE) ? "yes" : (Token.eq(token, Token.FALSE) ? "no" : Token.string(token)));
                if (value == null) {
                    throw new BaseXException(Options.allowed(option, Token.string(token), eo.values()), new Object[0]);
                }
            }
        } else if (option instanceof OptionsOption) {
            if (item instanceof XQMap) {
                value = ((OptionsOption)option).newInstance();
                ((Options)value).assign((XQMap)item, error, ii);
            } else {
                expected = "Invalid '%' value '%'; must be a map.";
            }
        } else if (option instanceof FuncOption) {
            if (item instanceof FuncItem) {
                value = item;
            } else {
                expected = "Invalid '%' value '%'; must be a function.";
            }
        } else {
            throw Util.notExpected("Unsupported option: " + option, new Object[0]);
        }
        if (expected != null) {
            throw new BaseXException(expected, option.name(), item);
        }
        this.put(option, value);
    }

    private synchronized boolean assign(String name, String value, int index, boolean error) throws BaseXException {
        Option<?> option = this.options.get(name);
        if (option == null) {
            if (error) {
                throw new BaseXException(this.error(name), new Object[0]);
            }
            return false;
        }
        if (option instanceof BooleanOption) {
            boolean v;
            if (value == null || value.isEmpty()) {
                Boolean b = this.get((BooleanOption)option);
                if (b == null) {
                    throw new BaseXException("Invalid '%' value '%'; must be 'yes', 'no', or a boolean.", option.name(), "");
                }
                v = b == false;
            } else {
                v = Strings.toBoolean(value);
                if (!v && !Strings.no(value)) {
                    throw new BaseXException("Invalid '%' value '%'; must be 'yes', 'no', or a boolean.", option.name(), value);
                }
            }
            this.put(option, v);
        } else if (option instanceof NumberOption) {
            int v = Strings.toInt(value);
            if (v == Integer.MIN_VALUE) {
                throw new BaseXException("Invalid '%' value '%'; must be a number.", option.name(), value);
            }
            this.put(option, v);
        } else if (option instanceof StringOption) {
            this.put(option, value);
        } else if (option instanceof EnumOption) {
            EnumOption eo = (EnumOption)option;
            Object v = eo.get(value);
            if (v == null) {
                throw new BaseXException(Options.allowed(option, value, eo.values()), new Object[0]);
            }
            this.put(option, v);
        } else if (option instanceof OptionsOption) {
            Object o = ((OptionsOption)option).newInstance();
            ((Options)o).assign(value);
            this.put(option, o);
        } else if (option instanceof NumbersOption) {
            int v = Strings.toInt(value);
            if (v == Integer.MIN_VALUE) {
                throw new BaseXException("Invalid '%' value '%'; must be a number.", option.name(), value);
            }
            int[] ii = (int[])this.get(option);
            if (index == -1) {
                if (ii == null) {
                    ii = new int[]{};
                }
                IntList il = new IntList(ii.length + 1);
                for (int i : ii) {
                    il.add(i);
                }
                this.put(option, il.add(v).finish());
            } else {
                if (index < 0 || index >= ii.length) {
                    throw new BaseXException("List counter for '%' is invalid.", option.name());
                }
                ii[index] = v;
            }
        } else if (option instanceof StringsOption) {
            String[] ss = (String[])this.get(option);
            if (index == -1) {
                if (ss == null) {
                    ss = new String[]{};
                }
                StringList sl = new StringList(ss.length + 1);
                for (String s : ss) {
                    sl.add(s);
                }
                this.put(option, ((StringList)((Object)sl.add(value))).finish());
            } else if (index == 0) {
                int v = Strings.toInt(value);
                if (v == Integer.MIN_VALUE) {
                    throw new BaseXException("Invalid '%' value '%'; must be a number.", option.name(), value);
                }
                this.values.put(name, new String[v]);
            } else {
                if (index <= 0 || index > ss.length) {
                    throw new BaseXException("List counter for '%' is invalid.", option.name());
                }
                ss[index - 1] = value;
            }
        } else {
            throw Util.notExpected("Unsupported option: " + option, new Object[0]);
        }
        return true;
    }

    public static enum YesNoOmit {
        YES,
        NO,
        OMIT;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static enum YesNo {
        YES,
        NO;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

