/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.list.ElementList;

public class IntList
extends ElementList {
    protected int[] list;

    public IntList() {
        this(8L);
    }

    public IntList(long capacity) {
        this.list = new int[Array.checkCapacity(capacity)];
    }

    public IntList(double factor) {
        this();
        this.factor = factor;
    }

    public IntList(int[] elements) {
        this.list = elements;
        this.size = elements.length;
    }

    public final IntList add(int element) {
        int s = this.size;
        int[] lst = this.list;
        if (s == lst.length) {
            lst = Arrays.copyOf(lst, this.newCapacity());
        }
        lst[s] = element;
        this.list = lst;
        this.size = s + 1;
        return this;
    }

    public final IntList add(int ... elements) {
        int s = this.size;
        int l = elements.length;
        int ns = s + l;
        int[] lst = this.list;
        if (ns > lst.length) {
            lst = Arrays.copyOf(lst, this.newCapacity(ns));
        }
        Array.copyFromStart(elements, l, lst, s);
        this.list = lst;
        this.size = ns;
        return this;
    }

    public final int get(int index) {
        return this.list[index];
    }

    public final void set(int index, int element) {
        if (index >= this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newCapacity(index + 1));
        }
        this.list[index] = element;
        this.size = Math.max(this.size, index + 1);
    }

    public final boolean contains(int element) {
        int s = this.size;
        int[] lst = this.list;
        for (int i = 0; i < s; ++i) {
            if (lst[i] != element) continue;
            return true;
        }
        return false;
    }

    public final void insert(int index, int ... elements) {
        int l = elements.length;
        if (l == 0) {
            return;
        }
        if (this.size + l > this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newCapacity(this.size + l));
        }
        Array.insert(this.list, index, l, this.size, elements);
        this.size += l;
    }

    public final void removeAll(int element) {
        int[] lst = this.list;
        int sz = this.size;
        int s = 0;
        for (int i = 0; i < sz; ++i) {
            if (lst[i] == element) continue;
            lst[s++] = lst[i];
        }
        this.size = s;
    }

    public final int remove(int index) {
        int[] lst = this.list;
        int e = lst[index];
        Array.remove(lst, index, 1, this.size);
        --this.size;
        return e;
    }

    public final void incFrom(int diff, int index) {
        int[] lst = this.list;
        int sz = this.size;
        int a = index;
        while (a < sz) {
            int n = a++;
            lst[n] = lst[n] + diff;
        }
    }

    public final int peek() {
        return this.list[this.size - 1];
    }

    public final int pop() {
        return this.list[--this.size];
    }

    public final void push(int element) {
        this.add(element);
    }

    public final int sortedIndexOf(int element) {
        return Arrays.binarySearch(this.list, 0, this.size, element);
    }

    public final int[] toArray() {
        return Arrays.copyOf(this.list, this.size);
    }

    public final int[] finish() {
        int[] lst = this.list;
        this.list = null;
        int s = this.size;
        return s == lst.length ? lst : Arrays.copyOf(lst, s);
    }

    public final IntList ddo() {
        if (!this.isEmpty()) {
            this.sort();
            int i = 1;
            for (int j = 1; j < this.size; ++j) {
                while (j < this.size && this.list[i - 1] == this.list[j]) {
                    ++j;
                }
                if (j >= this.size) continue;
                this.list[i++] = this.list[j];
            }
            this.size = i;
        }
        return this;
    }

    public final int[] createOrder() {
        IntList il = Array.number(this.size);
        il.sort(this.list, true);
        return il.finish();
    }

    public IntList sort() {
        int s = this.size;
        if (s > 1) {
            Arrays.sort(this.list, 0, s);
        }
        return this;
    }

    public final void sort(byte[][] tok, boolean num, boolean asc) {
        this.sort(0, this.size, num, asc, tok);
    }

    public final void sort(double[] num, boolean asc) {
        this.sort(0, this.size, asc, num);
    }

    public final void sort(int[] num, boolean asc) {
        this.sort(0, this.size, asc, num);
    }

    public final void sort(long[] num, boolean asc) {
        this.sort(0, this.size, asc, num);
    }

    private void sort(int s, int e, boolean g, boolean f, byte[][] t) {
        int c;
        int a;
        if (e < 7) {
            block0: for (int i = s; i < e + s; ++i) {
                for (int j = i; j > s; --j) {
                    int h;
                    int n = h = g ? IntList.s(t[j - 1], t[j]) : IntList.d(t[j - 1], t[j]);
                    if (f ? h < 0 : h > 0) continue block0;
                    this.s(j, j - 1, t);
                }
            }
            return;
        }
        int m = s + (e >> 1);
        if (e > 7) {
            int l = s;
            int n = s + e - 1;
            if (e > 40) {
                int k = e >>> 3;
                l = this.m(l, l + k, l + (k << 1));
                m = this.m(m - k, m, m + k);
                n = this.m(n - (k << 1), n - k, n);
            }
            m = this.m(l, m, n);
        }
        byte[] v = t[m];
        int b = a = s;
        int d = c = s + e - 1;
        while (true) {
            int h;
            if (b <= c) {
                int n = h = g ? IntList.s(t[b], v) : IntList.d(t[b], v);
                if (!(!f ? h < 0 : h > 0)) {
                    if (h == 0) {
                        this.s(a++, b, t);
                    }
                    ++b;
                    continue;
                }
            }
            while (c >= b) {
                int n = h = g ? IntList.s(t[c], v) : IntList.d(t[c], v);
                if (!f ? h > 0 : h < 0) break;
                if (h == 0) {
                    this.s(c, d--, t);
                }
                --c;
            }
            if (b > c) break;
            this.s(b++, c--, t);
        }
        int n = s + e;
        int k = Math.min(a - s, b - a);
        this.s(s, b - k, k, t);
        k = Math.min(d - c, n - d - 1);
        this.s(b, n - k, k, t);
        k = b - a;
        if (k > 1) {
            this.sort(s, k, g, f, t);
        }
        if ((k = d - c) > 1) {
            this.sort(n - k, k, g, f, t);
        }
    }

    private void sort(int s, int e, boolean f, double[] t) {
        int c;
        int a;
        if (e < 7) {
            block0: for (int i = s; i < e + s; ++i) {
                for (int j = i; j > s; --j) {
                    double h = t[j - 1] - t[j];
                    if (f ? h < 0.0 : h > 0.0) continue block0;
                    this.s(j, j - 1, t);
                }
            }
            return;
        }
        int m = s + (e >> 1);
        if (e > 7) {
            int l = s;
            int n = s + e - 1;
            if (e > 40) {
                int k = e >>> 3;
                l = this.m(l, l + k, l + (k << 1));
                m = this.m(m - k, m, m + k);
                n = this.m(n - (k << 1), n - k, n);
            }
            m = this.m(l, m, n);
        }
        double v = t[m];
        int b = a = s;
        int d = c = s + e - 1;
        while (true) {
            double h;
            if (b <= c) {
                h = t[b] - v;
                if (!(!f ? h < 0.0 : h > 0.0)) {
                    if (h == 0.0) {
                        this.s(a++, b, t);
                    }
                    ++b;
                    continue;
                }
            }
            while (c >= b) {
                h = t[c] - v;
                if (!f ? h > 0.0 : h < 0.0) break;
                if (h == 0.0) {
                    this.s(c, d--, t);
                }
                --c;
            }
            if (b > c) break;
            this.s(b++, c--, t);
        }
        int n = s + e;
        int k = Math.min(a - s, b - a);
        this.s(s, b - k, k, t);
        k = Math.min(d - c, n - d - 1);
        this.s(b, n - k, k, t);
        k = b - a;
        if (k > 1) {
            this.sort(s, k, f, t);
        }
        if ((k = d - c) > 1) {
            this.sort(n - k, k, f, t);
        }
    }

    private void sort(int s, int e, boolean f, int[] t) {
        int c;
        int a;
        if (e < 7) {
            block0: for (int i = s; i < e + s; ++i) {
                for (int j = i; j > s; --j) {
                    int h = t[j - 1] - t[j];
                    if (f ? h < 0 : h > 0) continue block0;
                    this.s(j, j - 1, t);
                }
            }
            return;
        }
        int m = s + (e >> 1);
        if (e > 7) {
            int l = s;
            int n = s + e - 1;
            if (e > 40) {
                int k = e >>> 3;
                l = this.m(l, l + k, l + (k << 1));
                m = this.m(m - k, m, m + k);
                n = this.m(n - (k << 1), n - k, n);
            }
            m = this.m(l, m, n);
        }
        int v = t[m];
        int b = a = s;
        int d = c = s + e - 1;
        while (true) {
            int h;
            if (b <= c) {
                h = t[b] - v;
                if (!(!f ? h < 0 : h > 0)) {
                    if (h == 0) {
                        this.s(a++, b, t);
                    }
                    ++b;
                    continue;
                }
            }
            while (c >= b) {
                h = t[c] - v;
                if (!f ? h > 0 : h < 0) break;
                if (h == 0) {
                    this.s(c, d--, t);
                }
                --c;
            }
            if (b > c) break;
            this.s(b++, c--, t);
        }
        int n = s + e;
        int k = Math.min(a - s, b - a);
        this.s(s, b - k, k, t);
        k = Math.min(d - c, n - d - 1);
        this.s(b, n - k, k, t);
        k = b - a;
        if (k > 1) {
            this.sort(s, k, f, t);
        }
        if ((k = d - c) > 1) {
            this.sort(n - k, k, f, t);
        }
    }

    private void sort(int s, int e, boolean f, long[] t) {
        int c;
        int a;
        if (e < 7) {
            block0: for (int i = s; i < e + s; ++i) {
                for (int j = i; j > s; --j) {
                    long h = t[j - 1] - t[j];
                    if (f ? h < 0L : h > 0L) continue block0;
                    this.s(j, j - 1, t);
                }
            }
            return;
        }
        int m = s + (e >> 1);
        if (e > 7) {
            int l = s;
            int n = s + e - 1;
            if (e > 40) {
                int k = e >>> 3;
                l = this.m(l, l + k, l + (k << 1));
                m = this.m(m - k, m, m + k);
                n = this.m(n - (k << 1), n - k, n);
            }
            m = this.m(l, m, n);
        }
        long v = t[m];
        int b = a = s;
        int d = c = s + e - 1;
        while (true) {
            long h;
            if (b <= c) {
                h = t[b] - v;
                if (!(!f ? h < 0L : h > 0L)) {
                    if (h == 0L) {
                        this.s(a++, b, t);
                    }
                    ++b;
                    continue;
                }
            }
            while (c >= b) {
                h = t[c] - v;
                if (!f ? h > 0L : h < 0L) break;
                if (h == 0L) {
                    this.s(c, d--, t);
                }
                --c;
            }
            if (b > c) break;
            this.s(b++, c--, t);
        }
        int n = s + e;
        int k = Math.min(a - s, b - a);
        this.s(s, b - k, k, t);
        k = Math.min(d - c, n - d - 1);
        this.s(b, n - k, k, t);
        k = b - a;
        if (k > 1) {
            this.sort(s, k, f, t);
        }
        if ((k = d - c) > 1) {
            this.sort(n - k, k, f, t);
        }
    }

    private static int s(byte[] a, byte[] b) {
        double n = Token.toDouble(a) - Token.toDouble(b);
        return n > 0.0 ? 1 : (n < 0.0 ? -1 : 0);
    }

    private static int d(byte[] a, byte[] b) {
        return a == null ? (b == null ? 0 : -1) : (b == null ? 1 : Token.diff(a, b));
    }

    private void s(int a, int b, byte[][] t) {
        int l = this.list[a];
        this.list[a] = this.list[b];
        this.list[b] = l;
        byte[] c = t[a];
        t[a] = t[b];
        t[b] = c;
    }

    private void s(int a, int b, double[] t) {
        int l = this.list[a];
        this.list[a] = this.list[b];
        this.list[b] = l;
        double c = t[a];
        t[a] = t[b];
        t[b] = c;
    }

    private void s(int a, int b, int[] t) {
        int l = this.list[a];
        this.list[a] = this.list[b];
        this.list[b] = l;
        int c = t[a];
        t[a] = t[b];
        t[b] = c;
    }

    private void s(int a, int b, long[] t) {
        int l = this.list[a];
        this.list[a] = this.list[b];
        this.list[b] = l;
        long c = t[a];
        t[a] = t[b];
        t[b] = c;
    }

    private void s(int a, int b, int n, byte[][] t) {
        for (int i = 0; i < n; ++i) {
            this.s(a + i, b + i, t);
        }
    }

    private void s(int a, int b, int n, double[] t) {
        for (int i = 0; i < n; ++i) {
            this.s(a + i, b + i, t);
        }
    }

    private void s(int a, int b, int n, int[] t) {
        for (int i = 0; i < n; ++i) {
            this.s(a + i, b + i, t);
        }
    }

    private void s(int a, int b, int n, long[] t) {
        for (int i = 0; i < n; ++i) {
            this.s(a + i, b + i, t);
        }
    }

    private int m(int a, int b, int c) {
        return this.list[a] < this.list[b] ? (this.list[b] < this.list[c] ? b : (this.list[a] < this.list[c] ? c : a)) : (this.list[b] > this.list[c] ? b : (this.list[a] > this.list[c] ? c : a));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntList)) {
            return false;
        }
        IntList il = (IntList)obj;
        if (this.size != il.size) {
            return false;
        }
        for (int l = 0; l < this.size; ++l) {
            if (this.list[l] == il.list[l]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.list == null ? "" : Arrays.toString(this.toArray());
    }
}

