/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import org.basex.util.Array;
import org.basex.util.list.ElementList;

public class DoubleList
extends ElementList {
    protected double[] list;

    public DoubleList() {
        this(8L);
    }

    public DoubleList(long capacity) {
        this.list = new double[Array.checkCapacity(capacity)];
    }

    public final DoubleList add(double element) {
        int s = this.size;
        double[] lst = this.list;
        if (s == lst.length) {
            lst = Arrays.copyOf(lst, this.newCapacity());
        }
        lst[s] = element;
        this.list = lst;
        this.size = s + 1;
        return this;
    }

    public final DoubleList add(double ... elements) {
        int s = this.size;
        int l = elements.length;
        int ns = s + l;
        double[] lst = this.list;
        if (ns > lst.length) {
            lst = Arrays.copyOf(lst, this.newCapacity(ns));
        }
        Array.copyFromStart(elements, l, lst, s);
        this.list = lst;
        this.size = ns;
        return this;
    }

    public final double get(int index) {
        return this.list[index];
    }

    public final double[] toArray() {
        return Arrays.copyOf(this.list, this.size);
    }

    public double[] finish() {
        double[] lst = this.list;
        this.list = null;
        int s = this.size;
        return s == lst.length ? lst : Arrays.copyOf(lst, s);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DoubleList)) {
            return false;
        }
        DoubleList dl = (DoubleList)obj;
        if (this.size != dl.size) {
            return false;
        }
        for (int l = 0; l < this.size; ++l) {
            if (this.list[l] == dl.list[l]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.list == null ? "" : Arrays.toString(this.toArray());
    }
}

