/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import org.basex.core.MainOptions;
import org.basex.query.QueryException;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.http.HttpPayload;
import org.basex.util.http.HttpText;
import org.basex.util.http.MediaType;

public final class HttpResponse {
    private final InputInfo info;
    private final MainOptions options;

    public HttpResponse(InputInfo info, MainOptions options) {
        this.info = info;
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getResponse(HttpURLConnection conn, boolean body, String mtype) throws IOException, QueryException {
        InputStream is;
        ItemList items = new ItemList();
        FElem response = new FElem(HttpText.Q_RESPONSE).declareNS();
        items.add(response);
        String msg = conn.getResponseMessage();
        response.add(HttpText.STATUS, Token.token(conn.getResponseCode()));
        response.add(HttpText.MESSAGE, msg == null ? "" : msg);
        for (Map.Entry<String, List<String>> entry : conn.getHeaderFields().entrySet()) {
            String name = entry.getKey();
            if (name == null) continue;
            for (String value : entry.getValue()) {
                response.add(new FElem(HttpText.Q_HEADER).add("name", name).add("value", value));
            }
        }
        boolean error = false;
        try {
            is = conn.getInputStream();
        }
        catch (IOException ex) {
            Util.debug(ex);
            is = conn.getErrorStream();
            error = true;
        }
        if (is != null) {
            String ctype = conn.getContentType();
            MediaType type = error || mtype == null ? (ctype == null ? MediaType.TEXT_PLAIN : new MediaType(ctype)) : new MediaType(mtype);
            HttpPayload hp = new HttpPayload(is, body, this.info, this.options);
            try {
                response.add(hp.parse(type, error, conn.getHeaderField("Content-Encoding")));
                if (body) {
                    items.add(hp.payloads());
                }
            }
            finally {
                is.close();
            }
        }
        return items.value();
    }
}

