/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.Collection;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.InternalStemmer;
import org.basex.util.ft.Language;
import org.basex.util.ft.Stemmer;

final class GermanStemmer
extends InternalStemmer {
    private int subst;

    GermanStemmer(FTIterator fti) {
        super(fti);
    }

    @Override
    Stemmer get(Language lang, FTIterator fti) {
        return new GermanStemmer(fti);
    }

    @Override
    Collection<Language> languages() {
        return GermanStemmer.collection("de");
    }

    @Override
    protected byte[] stem(byte[] word) {
        this.subst = 0;
        int wl = word.length;
        return wl == 0 ? Token.EMPTY : GermanStemmer.part(GermanStemmer.resub(this.opt(this.strip(this.subst(new TokenBuilder(word)))))).finish();
    }

    private TokenBuilder subst(TokenBuilder tb) {
        this.subst = 0;
        int s = tb.size();
        TokenBuilder tmp = new TokenBuilder(s);
        int last = 0;
        int next = s > 0 ? tb.cp(0) : 0;
        int c = 0;
        while (c < s) {
            int curr = next;
            next = (c += tb.cl(c)) < s ? tb.cp(c) : 0;
            int sb = 0;
            if (curr == last) {
                curr = 42;
            } else if (curr == 228) {
                curr = 97;
            } else if (curr == 246) {
                curr = 111;
            } else if (curr == 252) {
                curr = 117;
            } else if (curr == 223) {
                tmp.add(115);
                curr = 115;
                ++this.subst;
            } else if (curr == 115 && next == 99 && c + 1 < s && tb.get(c + 1) == 104) {
                curr = 1;
                sb = 2;
            } else if (curr == 99 && next == 104) {
                curr = 2;
                sb = 1;
            } else if (curr == 101 && next == 105) {
                curr = 3;
                sb = 1;
            } else if (curr == 105 && next == 101) {
                curr = 4;
                sb = 1;
            } else if (curr == 105 && next == 103) {
                curr = 5;
                sb = 1;
            } else if (curr == 115 && next == 116) {
                curr = 6;
                sb = 1;
            }
            if (sb > 0) {
                next = (c += sb) < s ? tb.cp(c) : 0;
                this.subst += sb;
            }
            last = curr;
            tmp.add(curr);
        }
        return tmp;
    }

    private TokenBuilder strip(TokenBuilder tb) {
        while (tb.size() > 3) {
            int tl = tb.size();
            byte c1 = tb.get(tl - 1);
            byte c2 = tb.get(tl - 2);
            if (tl + this.subst > 5 && c2 == 110 && c1 == 100 || tl + this.subst > 4 && c2 == 101 && (c1 == 109 || c1 == 114)) {
                tb.size(tl - 2);
                continue;
            }
            if (c1 != 101 && c1 != 115 && c1 != 110 && c1 != 116) break;
            tb.size(tl - 1);
        }
        return tb;
    }

    private TokenBuilder opt(TokenBuilder tb) {
        int tl = tb.size();
        if (tl > 5 && tb.get(tl - 5) == 101 && tb.get(tl - 4) == 114 && tb.get(tl - 3) == 105 && tb.get(tl - 2) == 110 && tb.get(tl - 1) == 42) {
            tb.size(tl - 1);
            this.strip(tb);
        }
        if ((tl = tb.size()) > 0 && tb.get(tl - 1) == 122) {
            tb.set(tl - 1, (byte)120);
        }
        return tb;
    }

    private static TokenBuilder resub(TokenBuilder tb) {
        TokenBuilder tmp = new TokenBuilder();
        int s = tb.size();
        block9: for (int c = 0; c < s; ++c) {
            byte ch = tb.get(c);
            switch (ch) {
                case 42: {
                    tmp.add(tmp.get(c - 1));
                    continue block9;
                }
                case 1: {
                    tmp.add(115).add(99).add(104);
                    continue block9;
                }
                case 2: {
                    tmp.add(99).add(104);
                    continue block9;
                }
                case 3: {
                    tmp.add(101).add(105);
                    continue block9;
                }
                case 4: {
                    tmp.add(105).add(101);
                    continue block9;
                }
                case 5: {
                    tmp.add(105).add(103);
                    continue block9;
                }
                case 6: {
                    tmp.add(115).add(116);
                    continue block9;
                }
                default: {
                    tmp.add(ch);
                }
            }
        }
        return tmp;
    }

    private static TokenBuilder part(TokenBuilder tb) {
        for (int c = 0; c < tb.size() - 3; ++c) {
            if (tb.get(c) != 103 || tb.get(c + 1) != 101 || tb.get(c + 2) != 103 || tb.get(c + 3) != 101) continue;
            tb.delete(c, c + 2);
            break;
        }
        return tb;
    }
}

