/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

public final class Performance {
    private long time = System.nanoTime();

    public long ns() {
        return this.ns(true);
    }

    public long ns(boolean reset) {
        long time2 = System.nanoTime();
        long diff = time2 - this.time;
        if (reset) {
            this.time = time2;
        }
        return diff;
    }

    public String getTime() {
        return this.getTime(1);
    }

    public String getTime(int runs) {
        long time2 = System.nanoTime();
        String t = Performance.getTime(time2 - this.time, runs);
        this.time = time2;
        return t;
    }

    public static double ms(long nano, int runs) {
        return (double)Math.round((double)nano / 10000.0 / (double)runs) / 100.0;
    }

    public static String getTime(long nano, int runs) {
        return Performance.ms(nano, runs) + " ms" + (runs > 1 ? " (avg)" : "");
    }

    public static String getMemory() {
        return Performance.format(Performance.memory());
    }

    public static String format(long size) {
        String num = Long.toString(size);
        int nl = num.length();
        if (nl > 16) {
            return Performance.units(size, 0x10000000000L) + " PB";
        }
        if (nl > 13) {
            return Performance.units(size, 0x10000000000L) + " TB";
        }
        if (nl > 10) {
            return Performance.units(size, 0x40000000L) + " GB";
        }
        if (nl > 7) {
            return Performance.units(size, 0x100000L) + " MB";
        }
        if (nl > 4) {
            return Performance.units(size, 1024L) + " kB";
        }
        return num + " b";
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(Math.max(0L, ms));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void gc(int count) {
        for (int c = 0; c < count; ++c) {
            System.gc();
        }
    }

    public static long memory() {
        Runtime rt = Runtime.getRuntime();
        return rt.totalMemory() - rt.freeMemory();
    }

    private static long units(long number, long size) {
        return (number + size - 1L) / size;
    }

    public String toString() {
        return this.getTime();
    }
}

