/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.InputParser;
import org.basex.util.Strings;

public final class InputInfo {
    private boolean internal;
    private final String path;
    private String input;
    private int line;
    private int col;

    public InputInfo(InputParser parser) {
        this.input = parser.input;
        this.path = parser.file;
        this.col = parser.pos;
    }

    public InputInfo(String path, int line, int col) {
        this.path = path;
        this.line = line;
        this.col = col;
    }

    public String path() {
        return this.path;
    }

    public int line() {
        this.init();
        return this.line;
    }

    public int column() {
        this.init();
        return this.col;
    }

    private void init() {
        int ch;
        if (this.line != 0) {
            return;
        }
        int cl = Math.min(this.col, this.input.length());
        String q = this.input;
        int l = 1;
        int c = 1;
        for (int i = 0; i < cl; i += Character.charCount(ch)) {
            ch = q.codePointAt(i);
            if (ch == 10) {
                ++l;
                c = 1;
                continue;
            }
            if (ch == 13) continue;
            ++c;
        }
        this.line = l;
        this.col = c;
    }

    public boolean internal() {
        return this.internal;
    }

    public void internal(boolean value) {
        this.internal = value;
    }

    public boolean equals(Object object) {
        if (!(object instanceof InputInfo)) {
            return false;
        }
        InputInfo ii = (InputInfo)object;
        return (this.path != null ? this.path.equals(ii.path) : this.input.equals(ii.input)) && this.column() == ii.column() && this.line() == ii.line();
    }

    public int hashCode() {
        return (this.path != null ? this.path.hashCode() : this.input.hashCode()) + this.column() + (this.line() << 16);
    }

    public String toString() {
        return Strings.concat(this.path == null ? "." : this.path, ", ", this.line(), Character.valueOf('/'), this.column());
    }
}

