/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.value.item.Item;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class MapType
extends FuncType {
    MapType(AtomType keyType, SeqType declType) {
        super(declType, keyType.seqType());
    }

    @Override
    public XQMap cast(Item item, QueryContext qc, StaticContext sc, InputInfo ii) throws QueryException {
        XQMap m;
        if (item instanceof XQMap && (m = (XQMap)item).instanceOf(this)) {
            return m;
        }
        throw QueryError.typeError(item, this, ii);
    }

    @Override
    public boolean eq(Type type) {
        if (this == type) {
            return true;
        }
        if (!(type instanceof MapType)) {
            return false;
        }
        MapType mt = (MapType)type;
        return this.keyType().eq(mt.keyType()) && this.declType.eq(mt.declType);
    }

    @Override
    public boolean instanceOf(Type type) {
        if (type.oneOf(SeqType.MAP, SeqType.FUNCTION, AtomType.ITEM)) {
            return true;
        }
        if (!(type instanceof FuncType) || type instanceof ArrayType) {
            return false;
        }
        FuncType ft = (FuncType)type;
        return this.declType.instanceOf(ft.declType) && (type instanceof MapType ? this.keyType().instanceOf(((MapType)type).keyType()) : ft.argTypes.length == 1 && ft.argTypes[0].instanceOf(SeqType.ANY_ATOMIC_TYPE_O));
    }

    @Override
    public Type union(Type type) {
        if (this.instanceOf(type)) {
            return type;
        }
        if (type.instanceOf(this)) {
            return this;
        }
        if (type instanceof MapType) {
            MapType mt = (MapType)type;
            return MapType.get((AtomType)this.keyType().union(mt.keyType()), this.declType.union(mt.declType));
        }
        return type instanceof ArrayType ? SeqType.FUNCTION : (type instanceof FuncType ? type.union(this) : AtomType.ITEM);
    }

    @Override
    public Type intersect(Type type) {
        if (this.instanceOf(type)) {
            return this;
        }
        if (type.instanceOf(this)) {
            return type;
        }
        if (!(type instanceof FuncType) || type instanceof ArrayType) {
            return null;
        }
        FuncType ft = (FuncType)type;
        SeqType dt = this.declType.intersect(ft.declType);
        if (dt == null) {
            return null;
        }
        if (type instanceof MapType) {
            MapType mt = (MapType)type;
            AtomType kt = (AtomType)this.keyType().intersect(mt.keyType());
            return kt != null ? MapType.get(kt, dt) : null;
        }
        return ft.argTypes.length == 1 && ft.argTypes[0].instanceOf(SeqType.ANY_ATOMIC_TYPE_O) ? new FuncType(dt, ft.argTypes[0].union(SeqType.ANY_ATOMIC_TYPE_O)) : null;
    }

    public AtomType keyType() {
        return (AtomType)this.argTypes[0].type;
    }

    public static MapType get(AtomType keyType, SeqType declType) {
        return keyType == AtomType.ANY_ATOMIC_TYPE && declType.eq(SeqType.ITEM_ZM) ? SeqType.MAP : new MapType(keyType, declType);
    }

    @Override
    public String toString() {
        Object[] objectArray;
        if (this == SeqType.MAP) {
            objectArray = WILDCARD;
        } else {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = this.keyType();
            objectArray = objectArray2;
            objectArray2[1] = this.declType;
        }
        Object[] param = objectArray;
        return new QueryString().token("map").params(param).toString();
    }
}

