/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq.tree;

import java.util.Iterator;
import java.util.ListIterator;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.iter.BasicIter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.seq.tree.SmallSeq;
import org.basex.query.value.seq.tree.TreeSeqBuilder;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.InputInfo;

public abstract class TreeSeq
extends Seq {
    static final int MIN_LEAF = 8;
    static final int MAX_LEAF = 15;
    static final int MIN_DIGIT = 4;
    static final int MAX_DIGIT = 19;
    static final int MAX_SMALL = 7;

    TreeSeq(long size, Type type) {
        super(size, type == null ? AtomType.ITEM : type);
    }

    @Override
    protected final Value copyInsert(long pos, Value value, QueryContext qc) {
        long i;
        long right = this.size - pos;
        if (value instanceof TreeSeq && (pos == 0L || right == 0L)) {
            TreeSeq other = (TreeSeq)value;
            return pos == 0L ? other.concat(this) : this.concat(other);
        }
        TreeSeqBuilder tsb = new TreeSeqBuilder();
        if (pos < 7L) {
            tsb.add(value, qc);
            i = pos;
            while (--i >= 0L) {
                tsb.addFront(this.itemAt(i));
            }
        } else {
            tsb.add(this.subsequence(0L, pos, qc), qc);
            tsb.add(value, qc);
        }
        if (right < 7L) {
            for (i = this.size - right; i < this.size; ++i) {
                tsb.add(this.itemAt(i));
            }
        } else {
            tsb.add(this.subsequence(pos, right, qc), qc);
        }
        return tsb.seq(this.type.union(value.type));
    }

    public abstract TreeSeq concat(TreeSeq var1);

    public abstract ListIterator<Item> iterator(long var1);

    @Override
    public final Iterator<Item> iterator() {
        return this.iterator(0L);
    }

    @Override
    public abstract BasicIter<Item> iter();

    @Override
    public final void cache(boolean lazy, InputInfo ii) throws QueryException {
        for (Item item : this) {
            item.cache(lazy, ii);
        }
    }

    @Override
    public final Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        ValueBuilder vb = new ValueBuilder(qc);
        for (Item item : this) {
            vb.add(item.atomValue(qc, ii));
        }
        return vb.value(AtomType.ANY_ATOMIC_TYPE);
    }

    @Override
    public final long atomSize() {
        long sz = 0L;
        for (Item item : this) {
            sz += item.atomSize();
        }
        return sz;
    }

    @Override
    public final Item ebv(QueryContext qc, InputInfo ii) throws QueryException {
        Item head = this.itemAt(0L);
        if (head instanceof ANode) {
            return head;
        }
        throw QueryError.EBV_X.get(ii, this);
    }

    abstract TreeSeq prepend(SmallSeq var1);

    static Item[] slice(Item[] items, int from, int to) {
        Item[] out = new Item[to - from];
        int in0 = Math.max(0, from);
        int in1 = Math.min(to, items.length);
        int out0 = Math.max(-from, 0);
        Array.copy(items, in0, in1 - in0, out, out0);
        return out;
    }

    static Item[] concat(Item[] as, Item[] bs) {
        int l = as.length;
        int r = bs.length;
        int n = l + r;
        Item[] out = new Item[n];
        Array.copy(as, l, out);
        Array.copyFromStart(bs, r, out, l);
        return out;
    }
}

