/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.iter.BasicIter;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.BlnSeq;
import org.basex.query.value.seq.BytSeq;
import org.basex.query.value.seq.DblSeq;
import org.basex.query.value.seq.DecSeq;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.FltSeq;
import org.basex.query.value.seq.IntSeq;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.seq.SubSeq;
import org.basex.query.value.seq.tree.TreeSeqBuilder;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.list.StringList;

public abstract class Seq
extends Value {
    protected long size;

    protected Seq(long size, Type type) {
        super(type);
        this.size = size;
    }

    @Override
    public Object toJava() throws QueryException {
        Type tp = null;
        for (Object item : this) {
            if (tp == null) {
                tp = ((Item)item).type;
                continue;
            }
            if (tp == ((Item)item).type) continue;
            tp = null;
            break;
        }
        if (tp != null) {
            this.type = tp;
            if (tp == AtomType.STRING) {
                StringList tmp = new StringList(Seq.initialCapacity(this.size));
                for (Item item : this) {
                    tmp.add(item.string(null));
                }
                return tmp.finish();
            }
            Value value = Seq.get((int)this.size, tp, this);
            if (value != null) {
                return value.toJava();
            }
        }
        int t = 0;
        Object[] tmp = new Object[(int)this.size];
        for (Item item : this) {
            tmp[t++] = item.toJava();
        }
        return tmp;
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final Item item(QueryContext qc, InputInfo ii) throws QueryException {
        throw QueryError.SEQFOUND_X.get(ii, this);
    }

    @Override
    public final Item test(QueryContext qc, InputInfo ii) throws QueryException {
        return this.ebv(qc, ii);
    }

    @Override
    public BasicIter<Item> iter() {
        return new BasicIter<Item>(this.size){

            @Override
            public Item get(long i) {
                return Seq.this.itemAt(i);
            }

            @Override
            public Value iterValue() {
                return Seq.this;
            }

            @Override
            public Value value(QueryContext qc, Expr expr) {
                return Seq.this;
            }
        };
    }

    @Override
    public boolean ddo() {
        return false;
    }

    @Override
    public final Value subsequence(long start, long length, QueryContext qc) {
        return length == 0L ? Empty.VALUE : (length == 1L ? this.itemAt(start) : (length == this.size() ? this : this.subSeq(start, length, qc)));
    }

    protected Seq subSeq(long offset, long length, QueryContext qc) {
        qc.checkStop();
        return new SubSeq(this, offset, length);
    }

    public final Value insertBefore(long pos, Value value, QueryContext qc) {
        long n = value.size();
        return n == 0L ? this : (n == 1L ? this.insert(pos, (Item)value, qc) : this.copyInsert(pos, value, qc));
    }

    public abstract Value insert(long var1, Item var3, QueryContext var4);

    protected Value copyInsert(long pos, Value value, QueryContext qc) {
        long i;
        Type tp = this.type.union(value.type);
        if (pos == this.size) {
            return new TreeSeqBuilder().add(this, qc).add(value, qc).seq(tp);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (i = 0L; i < pos; ++i) {
            vb.add(this.itemAt(i));
        }
        vb.add(value);
        for (i = pos; i < this.size; ++i) {
            vb.add(this.itemAt(i));
        }
        return vb.value(tp);
    }

    public abstract Value remove(long var1, QueryContext var3);

    final Value copyRemove(long pos, QueryContext qc) {
        long i;
        ValueBuilder vb = new ValueBuilder(qc);
        for (i = 0L; i < pos; ++i) {
            vb.add(this.itemAt(i));
        }
        for (i = pos + 1L; i < this.size; ++i) {
            vb.add(this.itemAt(i));
        }
        return vb.value(this.type);
    }

    @Override
    public final void refineType(Expr expr) {
        Type t = expr.seqType().type.intersect(this.type);
        if (t != null) {
            this.type = t;
        }
    }

    @Override
    public final int hash(InputInfo ii) throws QueryException {
        int h = 1;
        long v = Math.min(this.size, 5L);
        while (--v >= 0L) {
            h = 31 * h + this.itemAt(v).hash(ii);
        }
        return h;
    }

    @Override
    public final SeqType seqType() {
        return SeqType.get(this.type, Occ.ONE_OR_MORE);
    }

    @Override
    public boolean equals(Object obj) {
        Item item1;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Seq)) {
            return false;
        }
        Seq s = (Seq)obj;
        if (this.size != s.size) {
            return false;
        }
        BasicIter<Item> iter1 = this.iter();
        BasicIter<Item> iter2 = s.iter();
        while ((item1 = iter1.next()) != null) {
            if (item1.equals(iter2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String description() {
        return this.type + " " + "sequence";
    }

    @Override
    public void plan(QueryPlan plan) {
        int max = (int)Math.min(this.size, 5L);
        ExprList list = new ExprList(max);
        for (long i = 0L; i < (long)max; ++i) {
            list.add(this.itemAt(i));
        }
        plan.add(plan.create(this, new Object[0]), (ExprInfo[])list.finish());
    }

    @Override
    public final String toErrorString() {
        return this.build(true).toString();
    }

    @Override
    public void plan(QueryString qs) {
        qs.token(this.build(false).finish());
    }

    private TokenBuilder build(boolean error) {
        TokenBuilder tb = new TokenBuilder().add(40);
        int i = 0;
        while ((long)i < this.size) {
            if (i > 0) {
                tb.add(", ");
            }
            tb.add(error ? this.itemAt(i).toErrorString() : this.itemAt(i).toString());
            if (tb.size() > 40 && (long)(i + 1) != this.size) {
                tb.add(", ").add("...");
                break;
            }
            ++i;
        }
        return tb.add(41);
    }

    public static Value get(int size, Type type, Value ... values) throws QueryException {
        if (type == AtomType.STRING) {
            return StrSeq.get(size, values);
        }
        if (type == AtomType.BOOLEAN) {
            return BlnSeq.get(size, values);
        }
        if (type == AtomType.FLOAT) {
            return FltSeq.get(size, values);
        }
        if (type == AtomType.DOUBLE) {
            return DblSeq.get(size, values);
        }
        if (type == AtomType.DECIMAL) {
            return DecSeq.get(size, values);
        }
        if (type == AtomType.BYTE) {
            return BytSeq.get(size, values);
        }
        if (type != null && type.instanceOf(AtomType.INTEGER)) {
            return IntSeq.get(type, size, values);
        }
        return null;
    }

    public static int initialCapacity(long size) throws QueryException {
        if (size > 0x7FFFFFF7L) {
            throw QueryError.ARRAY_X_X.get(null, 0x7FFFFFF7, size);
        }
        return Array.initialCapacity(size);
    }
}

