/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.InputInfo;

public final class ItemSeq
extends Seq {
    private final Item[] items;

    private ItemSeq(Item[] items, int size, Type type) {
        super(size, type);
        this.items = items;
    }

    @Override
    public Item ebv(QueryContext qc, InputInfo ii) throws QueryException {
        Item head = this.items[0];
        if (head instanceof ANode) {
            return head;
        }
        throw QueryError.EBV_X.get(ii, this);
    }

    @Override
    public Item itemAt(long pos) {
        return this.items[(int)pos];
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        ValueBuilder vb = new ValueBuilder(qc);
        for (Item item : this) {
            vb.add(item.atomValue(qc, ii));
        }
        return vb.value(AtomType.ANY_ATOMIC_TYPE);
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        Item[] tmp = new Item[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.items[i];
        }
        return new ItemSeq(tmp, sz, this.type);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || (obj instanceof ItemSeq ? Array.equals(this.items, ((ItemSeq)obj).items) : super.equals(obj));
    }

    @Override
    public Value insert(long pos, Item item, QueryContext qc) {
        return this.copyInsert(pos, item, qc);
    }

    @Override
    public Value remove(long pos, QueryContext qc) {
        return this.copyRemove(pos, qc);
    }

    @Override
    public void cache(boolean lazy, InputInfo ii) throws QueryException {
        for (Item item : this) {
            item.cache(lazy, ii);
        }
    }

    @Override
    public long atomSize() {
        long sz = 0L;
        for (Item item : this) {
            sz += item.atomSize();
        }
        return sz;
    }

    public static Value get(Item[] values, int size, Type type) {
        return size == 0 ? Empty.VALUE : (size == 1 ? values[0] : new ItemSeq(values, size, type != null ? type : AtomType.ITEM));
    }

    public static Value get(Item[] values, int size, Expr expr) {
        return ItemSeq.get(values, size, expr != null ? expr.seqType().type : null);
    }
}

