/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import org.basex.query.QueryContext;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ExprInfo;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class FNSpace
extends FNode {
    private final byte[] name;

    public FNSpace(byte[] name, byte[] value) {
        super(NodeType.NAMESPACE_NODE);
        this.name = name;
        this.value = value;
    }

    @Override
    public QNm qname() {
        return new QNm(this.name);
    }

    @Override
    public byte[] name() {
        return this.name;
    }

    @Override
    public FNSpace materialize(QueryContext qc, boolean copy) {
        return copy ? new FNSpace(this.name, this.value) : this;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof FNSpace && Token.eq(this.name, ((FNSpace)obj).name) && super.equals(obj);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, "name", this.name, "value", this.value), new ExprInfo[0]);
    }

    @Override
    public void plan(QueryString qs) {
        TokenBuilder tb = new TokenBuilder().add(Token.XMLNS);
        if (this.name.length != 0) {
            tb.add(58).add(this.name);
        }
        tb.add(61).add(QueryString.toQuoted(this.value));
        qs.token(tb.finish());
    }
}

