/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import org.basex.data.Data;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.BufferInput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.iter.BasicIter;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Int;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.Util;

public abstract class Item
extends Value {
    public static final int UNDEF = Integer.MIN_VALUE;

    protected Item(Type type) {
        super(type);
    }

    @Override
    public BasicIter<Item> iter() {
        return new BasicIter<Item>(1L){

            @Override
            public Item get(long i) {
                return Item.this;
            }

            @Override
            public Value iterValue() {
                return Item.this;
            }

            @Override
            public Value value(QueryContext qc, Expr expr) {
                return Item.this;
            }
        };
    }

    @Override
    public final Item item(QueryContext qc, InputInfo ii) {
        return this;
    }

    @Override
    public final Item itemAt(long pos) {
        return this;
    }

    @Override
    public final Item reverse(QueryContext qc) {
        return this;
    }

    @Override
    public Item ebv(QueryContext qc, InputInfo ii) {
        return this;
    }

    @Override
    public Item test(QueryContext qc, InputInfo ii) throws QueryException {
        return this.bool(ii) ? this : null;
    }

    public abstract byte[] string(InputInfo var1) throws QueryException;

    public boolean bool(InputInfo ii) throws QueryException {
        throw QueryError.EBV_X_X.get(ii, this.type, this);
    }

    public BigDecimal dec(InputInfo ii) throws QueryException {
        return Dec.parse(this, ii);
    }

    public long itr(InputInfo ii) throws QueryException {
        return Int.parse(this, ii);
    }

    public float flt(InputInfo ii) throws QueryException {
        return Flt.parse(this.string(ii), ii);
    }

    public double dbl(InputInfo ii) throws QueryException {
        return Dbl.parse(this.string(ii), ii);
    }

    public boolean instanceOf(Type tp) {
        return this.type.instanceOf(tp);
    }

    public boolean comparable(Item item) {
        return this.type == item.type;
    }

    public abstract boolean eq(Item var1, Collation var2, StaticContext var3, InputInfo var4) throws QueryException;

    public final boolean equiv(Item item, Collation coll, InputInfo ii) throws QueryException {
        return (this == Dbl.NAN || this == Flt.NAN) && (item == Dbl.NAN || item == Flt.NAN) || this.comparable(item) && this.eq(item, coll, null, ii);
    }

    public boolean sameKey(Item item, InputInfo ii) throws QueryException {
        return this.comparable(item) && this.eq(item, null, null, ii);
    }

    public int diff(Item item, Collation coll, InputInfo ii) throws QueryException {
        throw QueryError.diffError(this, item, ii);
    }

    public BufferInput input(InputInfo ii) throws QueryException {
        return new ArrayInput(this.string(ii));
    }

    @Override
    public Value subsequence(long start, long length, QueryContext qc) {
        return length == 1L ? this : Empty.VALUE;
    }

    @Override
    public void cache(boolean lazy, InputInfo ii) throws QueryException {
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        return this;
    }

    @Override
    public Item atomItem(QueryContext qc, InputInfo ii) throws QueryException {
        return this;
    }

    @Override
    public long atomSize() {
        return 1L;
    }

    public Item materialize(QueryContext qc, boolean copy) {
        return this;
    }

    @Override
    public SeqType seqType() {
        return this.type.seqType();
    }

    @Override
    public long size() {
        return 1L;
    }

    @Override
    public void refineType(Expr expr) {
    }

    @Override
    public boolean ddo() {
        return this.type instanceof NodeType;
    }

    public final boolean persistent() {
        Data data = this.data();
        return data != null && !data.inMemory();
    }

    public double score() {
        return 0.0;
    }

    @Override
    public int hash(InputInfo ii) throws QueryException {
        return Token.hash(this.string(ii));
    }

    public byte[] xdmInfo() {
        return new byte[]{this.typeId().asByte()};
    }

    public Type.ID typeId() {
        return this.type.id();
    }

    @Override
    public String description() {
        return this.type + " " + "item";
    }

    @Override
    public void plan(QueryPlan plan) {
        try {
            plan.add(plan.create(this, new Object[0]), new Object[]{QueryString.toValue(this.string(null))});
        }
        catch (QueryException ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }
}

