/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.io.IOException;
import org.basex.io.IO;
import org.basex.io.in.BufferInput;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.func.Function;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Lazy;
import org.basex.util.InputInfo;

public final class B64Lazy
extends B64
implements Lazy {
    private final IO input;
    private final QueryError error;
    private boolean cache;

    public B64Lazy(IO input, QueryError error) {
        this.input = input;
        this.error = error;
    }

    @Override
    public byte[] binary(InputInfo ii) throws QueryException {
        this.cache(ii);
        return this.data;
    }

    @Override
    public BufferInput input(InputInfo ii) throws QueryException {
        if (this.cache) {
            this.cache(ii);
        }
        if (this.isCached()) {
            return super.input(ii);
        }
        try {
            return BufferInput.get(this.input);
        }
        catch (IOException ex) {
            throw this.error.get(ii, ex);
        }
    }

    @Override
    public void cache(boolean lazy, InputInfo ii) throws QueryException {
        if (lazy) {
            this.cache = true;
        } else {
            this.cache(ii);
        }
    }

    @Override
    public void cache(InputInfo ii) throws QueryException {
        try {
            if (!this.isCached()) {
                this.data = this.input.read();
            }
        }
        catch (IOException ex) {
            throw this.error.get(ii, ex);
        }
    }

    @Override
    public boolean isCached() {
        return this.data != null;
    }

    @Override
    public void plan(QueryString qs) {
        if (this.isCached()) {
            super.plan(qs);
        } else {
            qs.function(Function._FILE_READ_BINARY, this.input);
        }
    }
}

