/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import org.basex.query.util.fingertree.FingerTree;
import org.basex.query.util.fingertree.FingerTreeBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.array.BigArray;
import org.basex.query.value.array.LeafNode;
import org.basex.query.value.array.SmallArray;
import org.basex.query.value.array.XQArray;
import org.basex.util.Array;
import org.basex.util.Util;

public final class ArrayBuilder {
    private static final int CAP = 38;
    private static final int NODE_SIZE = 12;
    private final Value[] vals = new Value[38];
    private int inLeft;
    private int mid = 19;
    private int inRight;
    private final FingerTreeBuilder<Value> tree = new FingerTreeBuilder();

    public ArrayBuilder prepend(Value elem) {
        if (this.inLeft < 19) {
            this.vals[(this.mid - this.inLeft + 38 - 1) % 38] = elem;
            ++this.inLeft;
        } else if (this.tree.isEmpty() && this.inRight < 19) {
            this.mid = (this.mid + 38 - 1) % 38;
            this.vals[(this.mid - this.inLeft + 38) % 38] = elem;
            ++this.inRight;
        } else {
            Value[] leaf = new Value[12];
            int start = (this.mid - 12 + 38) % 38;
            for (int i = 0; i < 12; ++i) {
                leaf[i] = this.vals[(start + i) % 38];
            }
            this.tree.prepend(new LeafNode(leaf));
            int rest = this.inLeft - 12;
            int p0 = (this.mid - this.inLeft + 38) % 38;
            for (int i = 0; i < rest; ++i) {
                int from = (p0 + i) % 38;
                int to = (from + 12) % 38;
                this.vals[to] = this.vals[from];
            }
            this.vals[(this.mid - rest + 38 - 1) % 38] = elem;
            this.inLeft = rest + 1;
        }
        return this;
    }

    public ArrayBuilder append(Value elem) {
        if (this.inRight < 19) {
            this.vals[(this.mid + this.inRight) % 38] = elem;
            ++this.inRight;
        } else if (this.tree.isEmpty() && this.inLeft < 19) {
            this.mid = (this.mid + 1) % 38;
            this.vals[(this.mid + this.inRight + 38 - 1) % 38] = elem;
            ++this.inLeft;
        } else {
            Value[] leaf = new Value[12];
            int start = this.mid;
            for (int i = 0; i < 12; ++i) {
                leaf[i] = this.vals[(start + i) % 38];
            }
            this.tree.append(new LeafNode(leaf));
            int rest = this.inRight - 12;
            for (int i = 0; i < rest; ++i) {
                int to = (this.mid + i) % 38;
                int from = (to + 12) % 38;
                this.vals[to] = this.vals[from];
            }
            this.vals[(this.mid + rest) % 38] = elem;
            this.inRight = rest + 1;
        }
        return this;
    }

    public ArrayBuilder append(XQArray arr) {
        if (!(arr instanceof BigArray)) {
            for (Value value : arr.members()) {
                this.append(value);
            }
            return this;
        }
        BigArray big = (BigArray)arr;
        Value[] ls = big.left;
        Value[] rs = big.right;
        FingerTree<Value, Value> midTree = big.middle;
        if (midTree.isEmpty()) {
            for (Value l : big.left) {
                this.append(l);
            }
            for (Value r : big.right) {
                this.append(r);
            }
            return this;
        }
        if (this.tree.isEmpty()) {
            int k = this.inLeft + this.inRight;
            Value[] temp = new Value[k];
            int l = (this.mid - this.inLeft + 38) % 38;
            int m = 38 - l;
            if (k <= m) {
                Array.copyToStart(this.vals, l, k, temp);
            } else {
                Array.copyToStart(this.vals, l, m, temp);
                Array.copyFromStart(this.vals, k - m, temp, m);
            }
            this.inRight = 0;
            this.inLeft = 0;
            this.tree.append(midTree);
            int i = ls.length;
            while (--i >= 0) {
                this.prepend(ls[i]);
            }
            i = k;
            while (--i >= 0) {
                this.prepend(temp[i]);
            }
            for (Value r : rs) {
                this.append(r);
            }
            return this;
        }
        int inMiddle = this.inRight + big.left.length;
        int leaves = (inMiddle + 15 - 1) / 15;
        int leafSize = (inMiddle + leaves - 1) / leaves;
        int i = 0;
        for (int l = 0; l < leaves; ++l) {
            int inLeaf = Math.min(leafSize, inMiddle - i);
            Value[] leaf = new Value[inLeaf];
            for (int p = 0; p < inLeaf; ++p) {
                leaf[p] = i < this.inRight ? this.vals[(this.mid + i) % 38] : big.left[i - this.inRight];
                ++i;
            }
            this.tree.append(new LeafNode(leaf));
        }
        this.tree.append(big.middle);
        this.inRight = 0;
        for (Value r : big.right) {
            this.append(r);
        }
        return this;
    }

    public XQArray freeze() {
        int i;
        int n = this.inLeft + this.inRight;
        if (n == 0) {
            return XQArray.empty();
        }
        int start = (this.mid - this.inLeft + 38) % 38;
        if (n <= 7) {
            Value[] small = new Value[n];
            for (int i2 = 0; i2 < n; ++i2) {
                small[i2] = this.vals[(start + i2) % 38];
            }
            return new SmallArray(small);
        }
        int a = this.tree.isEmpty() ? n / 2 : this.inLeft;
        int b = n - a;
        Value[] ls = new Value[a];
        Value[] rs = new Value[b];
        for (i = 0; i < a; ++i) {
            ls[i] = this.vals[(start + i) % 38];
        }
        for (i = a; i < n; ++i) {
            rs[i - a] = this.vals[(start + i) % 38];
        }
        return new BigArray(ls, this.tree.freeze(), rs);
    }

    public String toString() {
        StringBuilder sb;
        block5: {
            block4: {
                sb = new StringBuilder(Util.className(this)).append('[');
                if (!this.tree.isEmpty()) break block4;
                int n = this.inLeft + this.inRight;
                int first = (this.mid - this.inLeft + 38) % 38;
                if (n <= 0) break block5;
                sb.append(this.vals[first]);
                for (int i = 1; i < n; ++i) {
                    sb.append(", ").append(this.vals[(first + i) % 38]);
                }
                break block5;
            }
            int first = (this.mid - this.inLeft + 38) % 38;
            sb.append(this.vals[first]);
            for (int i = 1; i < this.inLeft; ++i) {
                sb.append(", ").append(this.vals[(first + i) % 38]);
            }
            for (Value value : this.tree) {
                sb.append(", ").append(value);
            }
            for (int i = 0; i < this.inRight; ++i) {
                sb.append(", ").append(this.vals[(this.mid + i) % 38]);
            }
        }
        return sb.append(']').toString();
    }
}

