/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value;

import java.util.Collections;
import java.util.Iterator;
import org.basex.query.QueryContext;
import org.basex.query.expr.Expr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.seq.tree.TreeSeqBuilder;
import org.basex.query.value.type.Type;
import org.basex.util.Util;

public final class ValueBuilder {
    private final QueryContext qc;
    private Value firstValue;
    private TreeSeqBuilder builder;

    public ValueBuilder(QueryContext qc) {
        this.qc = qc;
    }

    public ValueBuilder(QueryContext qc, Item item1, Item item2) {
        this(qc);
        this.builder = new TreeSeqBuilder().add(item1).add(item2);
    }

    public static Value concat(Value value1, Value value2, QueryContext qc) {
        long size1 = value1.size();
        if (size1 == 0L) {
            return value2;
        }
        long size2 = value2.size();
        if (size2 == 0L) {
            return value1;
        }
        if (size1 > 1L) {
            return ((Seq)value1).insertBefore(size1, value2, qc);
        }
        if (size2 > 1L) {
            return ((Seq)value2).insert(0L, (Item)value1, qc);
        }
        return TreeSeqBuilder.concat((Item)value1, (Item)value2);
    }

    public ValueBuilder addFront(Item item) {
        this.qc.checkStop();
        TreeSeqBuilder tree = this.builder;
        if (tree != null) {
            tree.addFront(item);
        } else {
            Value first = this.firstValue;
            if (first != null) {
                this.builder = new TreeSeqBuilder().add(first, this.qc).addFront(item);
                this.firstValue = null;
            } else {
                this.firstValue = item;
            }
        }
        return this;
    }

    public ValueBuilder add(Item item) {
        this.qc.checkStop();
        TreeSeqBuilder tree = this.builder;
        if (tree != null) {
            tree.add(item);
        } else {
            Value first = this.firstValue;
            if (first != null) {
                this.builder = new TreeSeqBuilder().add(first, this.qc).add(item);
                this.firstValue = null;
            } else {
                this.firstValue = item;
            }
        }
        return this;
    }

    public ValueBuilder add(Value value) {
        if (value.isEmpty()) {
            this.qc.checkStop();
            return this;
        }
        TreeSeqBuilder tree = this.builder;
        if (tree != null) {
            tree.add(value, this.qc);
        } else {
            Value first = this.firstValue;
            if (first != null) {
                this.builder = new TreeSeqBuilder().add(first, this.qc).add(value, this.qc);
                this.firstValue = null;
            } else {
                this.firstValue = value;
            }
        }
        return this;
    }

    public Value value() {
        return this.value((Type)null);
    }

    public Value value(Type type) {
        Value first = this.firstValue;
        if (first != null) {
            return first;
        }
        TreeSeqBuilder tree = this.builder;
        return tree != null ? tree.seq(type) : Empty.VALUE;
    }

    public Value value(Expr expr) {
        return this.value(expr != null ? expr.seqType().type : null);
    }

    public String toString() {
        Iterator<Item> iter;
        StringBuilder sb = new StringBuilder(Util.className(this)).append('[');
        Iterator<Item> iterator = this.firstValue != null ? this.firstValue.iterator() : (iter = this.builder != null ? this.builder.iterator() : Collections.emptyIterator());
        if (iter.hasNext()) {
            sb.append(iter.next());
            while (iter.hasNext()) {
                sb.append(", ").append(iter.next());
            }
        }
        return sb.append(']').toString();
    }
}

