/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.regex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.basex.query.util.regex.CharClass;
import org.basex.query.util.regex.CharGroup;
import org.basex.query.util.regex.CharRange;
import org.basex.query.util.regex.RegExp;

public final class Escape
extends RegExp {
    private static final Comparator<int[]> CMP = Comparator.comparingInt(o -> o[0]);
    private static final Map<String, CharRange[]> MAP = new HashMap<String, CharRange[]>();
    private static final String INITIAL;
    private static final String NOT_INITIAL;
    private static final String CHAR;
    private static final String NOT_CHAR;
    private static final String WORD;
    private static final String NOT_WORD;
    private static final String DIGIT = "\\p{Nd}";
    private static final String NOT_DIGIT = "\\P{Nd}";
    private final String img;

    private Escape(String img) {
        this.img = img;
    }

    public static RegExp get(String esc) {
        String e;
        if (esc.startsWith("\\p{Is") || esc.startsWith("\\P{Is")) {
            RegExp[] rng = MAP.get(esc);
            return rng != null ? new CharClass(new CharGroup(rng), null) : null;
        }
        switch (esc.charAt(1)) {
            case 'i': {
                e = '[' + INITIAL + ']';
                break;
            }
            case 'I': {
                e = '[' + NOT_INITIAL + ']';
                break;
            }
            case 'c': {
                e = '[' + CHAR + ']';
                break;
            }
            case 'C': {
                e = '[' + NOT_CHAR + ']';
                break;
            }
            case 'd': {
                e = DIGIT;
                break;
            }
            case 'D': {
                e = NOT_DIGIT;
                break;
            }
            case 'w': {
                e = '[' + WORD + ']';
                break;
            }
            case 'W': {
                e = '[' + NOT_WORD + ']';
                break;
            }
            default: {
                e = esc;
            }
        }
        return new Escape(e);
    }

    public static char getCp(String single) {
        switch (single.charAt(1)) {
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
        }
        return single.charAt(1);
    }

    public static RegExp[] inGroup(String esc) {
        String e;
        RegExp[] rng;
        if ((esc.startsWith("\\p{Is") || esc.startsWith("\\P{Is")) && (rng = MAP.get(esc)) != null) {
            return rng;
        }
        if (esc.length() > 2) {
            return new RegExp[]{new Escape(esc)};
        }
        switch (esc.charAt(1)) {
            case 'i': {
                e = INITIAL;
                break;
            }
            case 'I': {
                e = NOT_INITIAL;
                break;
            }
            case 'c': {
                e = CHAR;
                break;
            }
            case 'C': {
                e = NOT_CHAR;
                break;
            }
            case 'd': {
                e = DIGIT;
                break;
            }
            case 'D': {
                e = NOT_DIGIT;
                break;
            }
            case 'w': {
                e = WORD;
                break;
            }
            case 'W': {
                e = NOT_WORD;
                break;
            }
            default: {
                e = esc;
            }
        }
        return new RegExp[]{new Escape(e)};
    }

    @Override
    void toRegEx(StringBuilder sb) {
        sb.append(this.img);
    }

    private static int[][] read(String string) {
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        int sl = string.length();
        for (int s = 0; s < sl; s += Character.charCount(rng[1])) {
            int[] rng = new int[]{string.codePointAt(s), string.codePointAt(s += Character.charCount(rng[0]))};
            ranges.add(rng);
        }
        return (int[][])ranges.toArray((T[])new int[ranges.size()][]);
    }

    private static int[][] merge(int[][] ... rss) {
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        for (int[][] rs : rss) {
            Collections.addAll(ranges, rs);
        }
        ranges.sort(CMP);
        for (int i = 0; i < ranges.size(); ++i) {
            int[] rng2;
            int[] rng = (int[])ranges.get(i);
            while (i + 1 < ranges.size() && (rng2 = (int[])ranges.get(i + 1))[0] - rng[1] <= 1) {
                rng[1] = rng2[1];
                ranges.remove(i + 1);
            }
        }
        return (int[][])ranges.toArray((T[])new int[ranges.size()][]);
    }

    private static int[][] invert(int[][] rng) {
        int start = 0;
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        for (int[] in : rng) {
            if (in[0] - 1 >= start) {
                ranges.add(new int[]{start, in[0] - 1});
            }
            start = in[1] + 1;
        }
        if (start <= 0x10FFFF) {
            ranges.add(new int[]{start, 0x10FFFF});
        }
        return (int[][])ranges.toArray((T[])new int[ranges.size()][]);
    }

    private static String serialize(int[][] ranges) {
        StringBuilder sb = new StringBuilder();
        for (int[] rng : ranges) {
            sb.append(Escape.escape(rng[0]));
            if (rng[1] == rng[0]) continue;
            sb.append('-').append(Escape.escape(rng[1]));
        }
        return sb.toString();
    }

    static char[] escape(int cp) {
        switch (cp) {
            case 45: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                return new char[]{'\\', (char)cp};
            }
            case 10: {
                return new char[]{'\\', 'n'};
            }
            case 13: {
                return new char[]{'\\', 'r'};
            }
            case 9: {
                return new char[]{'\\', 't'};
            }
        }
        return Character.toChars(cp);
    }

    private static void add(Map<String, int[][]> m, String n, int[] r) {
        int[][] old = m.get(n);
        int[][] nw = new int[][]{r};
        m.put(n, old == null ? nw : (int[][])Escape.merge(old, nw));
    }

    static {
        int[][] baseChar = Escape.read("AZaz\u00c0\u00d6\u00d8\u00f6\u00f8\u00ff\u0100\u0131\u0134\u013e\u0141\u0148\u014a\u017e\u0180\u01c3\u01cd\u01f0\u01f4\u01f5\u01fa\u0217\u0250\u02a8\u02bb\u02c1\u0386\u0386\u0388\u038a\u038c\u038c\u038e\u03a1\u03a3\u03ce\u03d0\u03d6\u03da\u03da\u03dc\u03dc\u03de\u03de\u03e0\u03e0\u03e2\u03f3\u0401\u040c\u040e\u044f\u0451\u045c\u045e\u0481\u0490\u04c4\u04c7\u04c8\u04cb\u04cc\u04d0\u04eb\u04ee\u04f5\u04f8\u04f9\u0531\u0556\u0559\u0559\u0561\u0586\u05d0\u05ea\u05f0\u05f2\u0621\u063a\u0641\u064a\u0671\u06b7\u06ba\u06be\u06c0\u06ce\u06d0\u06d3\u06d5\u06d5\u06e5\u06e6\u0905\u0939\u093d\u093d\u0958\u0961\u0985\u098c\u098f\u0990\u0993\u09a8\u09aa\u09b0\u09b2\u09b2\u09b6\u09b9\u09dc\u09dd\u09df\u09e1\u09f0\u09f1\u0a05\u0a0a\u0a0f\u0a10\u0a13\u0a28\u0a2a\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a59\u0a5c\u0a5e\u0a5e\u0a72\u0a74\u0a85\u0a8b\u0a8d\u0a8d\u0a8f\u0a91\u0a93\u0aa8\u0aaa\u0ab0\u0ab2\u0ab3\u0ab5\u0ab9\u0abd\u0abd\u0ae0\u0ae0\u0b05\u0b0c\u0b0f\u0b10\u0b13\u0b28\u0b2a\u0b30\u0b32\u0b33\u0b36\u0b39\u0b3d\u0b3d\u0b5c\u0b5d\u0b5f\u0b61\u0b85\u0b8a\u0b8e\u0b90\u0b92\u0b95\u0b99\u0b9a\u0b9c\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8\u0baa\u0bae\u0bb5\u0bb7\u0bb9\u0c05\u0c0c\u0c0e\u0c10\u0c12\u0c28\u0c2a\u0c33\u0c35\u0c39\u0c60\u0c61\u0c85\u0c8c\u0c8e\u0c90\u0c92\u0ca8\u0caa\u0cb3\u0cb5\u0cb9\u0cde\u0cde\u0ce0\u0ce1\u0d05\u0d0c\u0d0e\u0d10\u0d12\u0d28\u0d2a\u0d39\u0d60\u0d61\u0e01\u0e2e\u0e30\u0e30\u0e32\u0e33\u0e40\u0e45\u0e81\u0e82\u0e84\u0e84\u0e87\u0e88\u0e8a\u0e8a\u0e8d\u0e8d\u0e94\u0e97\u0e99\u0e9f\u0ea1\u0ea3\u0ea5\u0ea5\u0ea7\u0ea7\u0eaa\u0eab\u0ead\u0eae\u0eb0\u0eb0\u0eb2\u0eb3\u0ebd\u0ebd\u0ec0\u0ec4\u0f40\u0f47\u0f49\u0f69\u10a0\u10c5\u10d0\u10f6\u1100\u1100\u1102\u1103\u1105\u1107\u1109\u1109\u110b\u110c\u110e\u1112\u113c\u113c\u113e\u113e\u1140\u1140\u114c\u114c\u114e\u114e\u1150\u1150\u1154\u1155\u1159\u1159\u115f\u1161\u1163\u1163\u1165\u1165\u1167\u1167\u1169\u1169\u116d\u116e\u1172\u1173\u1175\u1175\u119e\u119e\u11a8\u11a8\u11ab\u11ab\u11ae\u11af\u11b7\u11b8\u11ba\u11ba\u11bc\u11c2\u11eb\u11eb\u11f0\u11f0\u11f9\u11f9\u1e00\u1e9b\u1ea0\u1ef9\u1f00\u1f15\u1f18\u1f1d\u1f20\u1f45\u1f48\u1f4d\u1f50\u1f57\u1f59\u1f59\u1f5b\u1f5b\u1f5d\u1f5d\u1f5f\u1f7d\u1f80\u1fb4\u1fb6\u1fbc\u1fbe\u1fbe\u1fc2\u1fc4\u1fc6\u1fcc\u1fd0\u1fd3\u1fd6\u1fdb\u1fe0\u1fec\u1ff2\u1ff4\u1ff6\u1ffc\u2126\u2126\u212a\u212b\u212e\u212e\u2180\u2182\u3041\u3094\u30a1\u30fa\u3105\u312c\uac00\ud7a3");
        int[][] ideographic = Escape.read("\u4e00\u9fa5\u3007\u3007\u3021\u3029");
        int[][] combiningChar = Escape.read("\u0300\u0345\u0360\u0361\u0483\u0486\u0591\u05a1\u05a3\u05b9\u05bb\u05bd\u05bf\u05bf\u05c1\u05c2\u05c4\u05c4\u064b\u0652\u0670\u0670\u06d6\u06dc\u06dd\u06df\u06e0\u06e4\u06e7\u06e8\u06ea\u06ed\u0901\u0903\u093c\u093c\u093e\u094c\u094d\u094d\u0951\u0954\u0962\u0963\u0981\u0983\u09bc\u09bc\u09be\u09be\u09bf\u09bf\u09c0\u09c4\u09c7\u09c8\u09cb\u09cd\u09d7\u09d7\u09e2\u09e3\u0a02\u0a02\u0a3c\u0a3c\u0a3e\u0a3e\u0a3f\u0a3f\u0a40\u0a42\u0a47\u0a48\u0a4b\u0a4d\u0a70\u0a71\u0a81\u0a83\u0abc\u0abc\u0abe\u0ac5\u0ac7\u0ac9\u0acb\u0acd\u0b01\u0b03\u0b3c\u0b3c\u0b3e\u0b43\u0b47\u0b48\u0b4b\u0b4d\u0b56\u0b57\u0b82\u0b83\u0bbe\u0bc2\u0bc6\u0bc8\u0bca\u0bcd\u0bd7\u0bd7\u0c01\u0c03\u0c3e\u0c44\u0c46\u0c48\u0c4a\u0c4d\u0c55\u0c56\u0c82\u0c83\u0cbe\u0cc4\u0cc6\u0cc8\u0cca\u0ccd\u0cd5\u0cd6\u0d02\u0d03\u0d3e\u0d43\u0d46\u0d48\u0d4a\u0d4d\u0d57\u0d57\u0e31\u0e31\u0e34\u0e3a\u0e47\u0e4e\u0eb1\u0eb1\u0eb4\u0eb9\u0ebb\u0ebc\u0ec8\u0ecd\u0f18\u0f19\u0f35\u0f35\u0f37\u0f37\u0f39\u0f39\u0f3e\u0f3e\u0f3f\u0f3f\u0f71\u0f84\u0f86\u0f8b\u0f90\u0f95\u0f97\u0f97\u0f99\u0fad\u0fb1\u0fb7\u0fb9\u0fb9\u20d0\u20dc\u20e1\u20e1\u302a\u302f\u3099\u3099\u309a\u309a");
        int[][] digit = Escape.read("09\u0660\u0669\u06f0\u06f9\u0966\u096f\u09e6\u09ef\u0a66\u0a6f\u0ae6\u0aef\u0b66\u0b6f\u0be7\u0bef\u0c66\u0c6f\u0ce6\u0cef\u0d66\u0d6f\u0e50\u0e59\u0ed0\u0ed9\u0f20\u0f29");
        int[][] extender = Escape.read("\u00b7\u00b7\u02d0\u02d0\u02d1\u02d1\u0387\u0387\u0640\u0640\u0e46\u0e46\u0ec6\u0ec6\u3005\u3005\u3031\u3035\u309d\u309e\u30fc\u30fe");
        int[][] word = Escape.read("$$++09<>AZ^^`z||~~\u00a2\u00aa\u00ac\u00ac\u00ae\u00b6\u00b8\u00ba\u00bc\u00be\u00c0\u0377\u037a\u037d\u0384\u0386\u0388\u038a\u038c\u038c\u038e\u03a1\u03a3\u0527\u0531\u0556\u0559\u0559\u0561\u0587\u0591\u05bd\u05bf\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u05c7\u05d0\u05ea\u05f0\u05f2\u0606\u0608\u060b\u060b\u060e\u061a\u0620\u0669\u066e\u06d3\u06d5\u06dc\u06de\u06ff\u0710\u074a\u074d\u07b1\u07c0\u07f6\u07fa\u07fa\u0800\u082d\u0840\u085b\u0900\u0963\u0966\u096f\u0971\u0977\u0979\u097f\u0981\u0983\u0985\u098c\u098f\u0990\u0993\u09a8\u09aa\u09b0\u09b2\u09b2\u09b6\u09b9\u09bc\u09c4\u09c7\u09c8\u09cb\u09ce\u09d7\u09d7\u09dc\u09dd\u09df\u09e3\u09e6\u09fb\u0a01\u0a03\u0a05\u0a0a\u0a0f\u0a10\u0a13\u0a28\u0a2a\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a3c\u0a3c\u0a3e\u0a42\u0a47\u0a48\u0a4b\u0a4d\u0a51\u0a51\u0a59\u0a5c\u0a5e\u0a5e\u0a66\u0a75\u0a81\u0a83\u0a85\u0a8d\u0a8f\u0a91\u0a93\u0aa8\u0aaa\u0ab0\u0ab2\u0ab3\u0ab5\u0ab9\u0abc\u0ac5\u0ac7\u0ac9\u0acb\u0acd\u0ad0\u0ad0\u0ae0\u0ae3\u0ae6\u0aef\u0af1\u0af1\u0b01\u0b03\u0b05\u0b0c\u0b0f\u0b10\u0b13\u0b28\u0b2a\u0b30\u0b32\u0b33\u0b35\u0b39\u0b3c\u0b44\u0b47\u0b48\u0b4b\u0b4d\u0b56\u0b57\u0b5c\u0b5d\u0b5f\u0b63\u0b66\u0b77\u0b82\u0b83\u0b85\u0b8a\u0b8e\u0b90\u0b92\u0b95\u0b99\u0b9a\u0b9c\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8\u0baa\u0bae\u0bb9\u0bbe\u0bc2\u0bc6\u0bc8\u0bca\u0bcd\u0bd0\u0bd0\u0bd7\u0bd7\u0be6\u0bfa\u0c01\u0c03\u0c05\u0c0c\u0c0e\u0c10\u0c12\u0c28\u0c2a\u0c33\u0c35\u0c39\u0c3d\u0c44\u0c46\u0c48\u0c4a\u0c4d\u0c55\u0c56\u0c58\u0c59\u0c60\u0c63\u0c66\u0c6f\u0c78\u0c7f\u0c82\u0c83\u0c85\u0c8c\u0c8e\u0c90\u0c92\u0ca8\u0caa\u0cb3\u0cb5\u0cb9\u0cbc\u0cc4\u0cc6\u0cc8\u0cca\u0ccd\u0cd5\u0cd6\u0cde\u0cde\u0ce0\u0ce3\u0ce6\u0cef\u0cf1\u0cf2\u0d02\u0d03\u0d05\u0d0c\u0d0e\u0d10\u0d12\u0d3a\u0d3d\u0d44\u0d46\u0d48\u0d4a\u0d4e\u0d57\u0d57\u0d60\u0d63\u0d66\u0d75\u0d79\u0d7f\u0d82\u0d83\u0d85\u0d96\u0d9a\u0db1\u0db3\u0dbb\u0dbd\u0dbd\u0dc0\u0dc6\u0dca\u0dca\u0dcf\u0dd4\u0dd6\u0dd6\u0dd8\u0ddf\u0df2\u0df3\u0e01\u0e3a\u0e3f\u0e4e\u0e50\u0e59\u0e81\u0e82\u0e84\u0e84\u0e87\u0e88\u0e8a\u0e8a\u0e8d\u0e8d\u0e94\u0e97\u0e99\u0e9f\u0ea1\u0ea3\u0ea5\u0ea5\u0ea7\u0ea7\u0eaa\u0eab\u0ead\u0eb9\u0ebb\u0ebd\u0ec0\u0ec4\u0ec6\u0ec6\u0ec8\u0ecd\u0ed0\u0ed9\u0edc\u0edd\u0f00\u0f03\u0f13\u0f39\u0f3e\u0f47\u0f49\u0f6c\u0f71\u0f84\u0f86\u0f97\u0f99\u0fbc\u0fbe\u0fcc\u0fce\u0fcf\u0fd5\u0fd8\u1000\u1049\u1050\u10c5\u10d0\u10fa\u10fc\u10fc\u1100\u1248\u124a\u124d\u1250\u1256\u1258\u1258\u125a\u125d\u1260\u1288\u128a\u128d\u1290\u12b0\u12b2\u12b5\u12b8\u12be\u12c0\u12c0\u12c2\u12c5\u12c8\u12d6\u12d8\u1310\u1312\u1315\u1318\u135a\u135d\u1360\u1369\u137c\u1380\u1399\u13a0\u13f4\u1401\u166c\u166f\u167f\u1681\u169a\u16a0\u16ea\u16ee\u16f0\u1700\u170c\u170e\u1714\u1720\u1734\u1740\u1753\u1760\u176c\u176e\u1770\u1772\u1773\u1780\u17b3\u17b6\u17d3\u17d7\u17d7\u17db\u17dd\u17e0\u17e9\u17f0\u17f9\u180b\u180d\u1810\u1819\u1820\u1877\u1880\u18aa\u18b0\u18f5\u1900\u191c\u1920\u192b\u1930\u193b\u1940\u1940\u1946\u196d\u1970\u1974\u1980\u19ab\u19b0\u19c9\u19d0\u19da\u19de\u1a1b\u1a20\u1a5e\u1a60\u1a7c\u1a7f\u1a89\u1a90\u1a99\u1aa7\u1aa7\u1b00\u1b4b\u1b50\u1b59\u1b61\u1b7c\u1b80\u1baa\u1bae\u1bb9\u1bc0\u1bf3\u1c00\u1c37\u1c40\u1c49\u1c4d\u1c7d\u1cd0\u1cd2\u1cd4\u1cf2\u1d00\u1de6\u1dfc\u1f15\u1f18\u1f1d\u1f20\u1f45\u1f48\u1f4d\u1f50\u1f57\u1f59\u1f59\u1f5b\u1f5b\u1f5d\u1f5d\u1f5f\u1f7d\u1f80\u1fb4\u1fb6\u1fc4\u1fc6\u1fd3\u1fd6\u1fdb\u1fdd\u1fef\u1ff2\u1ff4\u1ff6\u1ffe\u2044\u2044\u2052\u2052\u2070\u2071\u2074\u207c\u207f\u208c\u2090\u209c\u20a0\u20b9\u20d0\u20f0\u2100\u2189\u2190\u2328\u232b\u23f3\u2400\u2426\u2440\u244a\u2460\u26ff\u2701\u2767\u2776\u27c4\u27c7\u27ca\u27cc\u27cc\u27ce\u27e5\u27f0\u2982\u2999\u29d7\u29dc\u29fb\u29fe\u2b4c\u2b50\u2b59\u2c00\u2c2e\u2c30\u2c5e\u2c60\u2cf1\u2cfd\u2cfd\u2d00\u2d25\u2d30\u2d65\u2d6f\u2d6f\u2d7f\u2d96\u2da0\u2da6\u2da8\u2dae\u2db0\u2db6\u2db8\u2dbe\u2dc0\u2dc6\u2dc8\u2dce\u2dd0\u2dd6\u2dd8\u2dde\u2de0\u2dff\u2e2f\u2e2f\u2e80\u2e99\u2e9b\u2ef3\u2f00\u2fd5\u2ff0\u2ffb\u3004\u3007\u3012\u3013\u3020\u302f\u3031\u303c\u303e\u303f\u3041\u3096\u3099\u309f\u30a1\u30fa\u30fc\u30ff\u3105\u312d\u3131\u318e\u3190\u31ba\u31c0\u31e3\u31f0\u321e\u3220\u32fe\u3300\u4db5\u4dc0\u9fcb\ua000\ua48c\ua490\ua4c6\ua4d0\ua4fd\ua500\ua60c\ua610\ua62b\ua640\ua672\ua67c\ua67d\ua67f\ua697\ua6a0\ua6f1\ua700\ua78e\ua790\ua791\ua7a0\ua7a9\ua7fa\ua82b\ua830\ua839\ua840\ua873\ua880\ua8c4\ua8d0\ua8d9\ua8e0\ua8f7\ua8fb\ua8fb\ua900\ua92d\ua930\ua953\ua960\ua97c\ua980\ua9c0\ua9cf\ua9d9\uaa00\uaa36\uaa40\uaa4d\uaa50\uaa59\uaa60\uaa7b\uaa80\uaac2\uaadb\uaadd\uab01\uab06\uab09\uab0e\uab11\uab16\uab20\uab26\uab28\uab2e\uabc0\uabea\uabec\uabed\uabf0\uabf9\uac00\ud7a3\ud7b0\ud7c6\ud7cb\ud7fb\uf900\ufa2d\ufa30\ufa6d\ufa70\ufad9\ufb00\ufb06\ufb13\ufb17\ufb1d\ufb36\ufb38\ufb3c\ufb3e\ufb3e\ufb40\ufb41\ufb43\ufb44\ufb46\ufbc1\ufbd3\ufd3d\ufd50\ufd8f\ufd92\ufdc7\ufdd0\ufdfd\ufe00\ufe0f\ufe20\ufe26\ufe62\ufe62\ufe64\ufe66\ufe69\ufe69\ufe70\ufe74\ufe76\ufefc\uff04\uff04\uff0b\uff0b\uff10\uff19\uff1c\uff1e\uff21\uff3a\uff3e\uff3e\uff40\uff5a\uff5c\uff5c\uff5e\uff5e\uff66\uffbe\uffc2\uffc7\uffca\uffcf\uffd2\uffd7\uffda\uffdc\uffe0\uffe6\uffe8\uffee\ufffc\ufffd\ud800\udc00\ud800\udc0b\ud800\udc0d\ud800\udc26\ud800\udc28\ud800\udc3a\ud800\udc3c\ud800\udc3d\ud800\udc3f\ud800\udc4d\ud800\udc50\ud800\udc5d\ud800\udc80\ud800\udcfa\ud800\udd02\ud800\udd02\ud800\udd07\ud800\udd33\ud800\udd37\ud800\udd8a\ud800\udd90\ud800\udd9b\ud800\uddd0\ud800\uddfd\ud800\ude80\ud800\ude9c\ud800\udea0\ud800\uded0\ud800\udf00\ud800\udf1e\ud800\udf20\ud800\udf23\ud800\udf30\ud800\udf4a\ud800\udf80\ud800\udf9d\ud800\udfa0\ud800\udfc3\ud800\udfc8\ud800\udfcf\ud800\udfd1\ud800\udfd5\ud801\udc00\ud801\udc9d\ud801\udca0\ud801\udca9\ud802\udc00\ud802\udc05\ud802\udc08\ud802\udc08\ud802\udc0a\ud802\udc35\ud802\udc37\ud802\udc38\ud802\udc3c\ud802\udc3c\ud802\udc3f\ud802\udc55\ud802\udc58\ud802\udc5f\ud802\udd00\ud802\udd1b\ud802\udd20\ud802\udd39\ud802\ude00\ud802\ude03\ud802\ude05\ud802\ude06\ud802\ude0c\ud802\ude13\ud802\ude15\ud802\ude17\ud802\ude19\ud802\ude33\ud802\ude38\ud802\ude3a\ud802\ude3f\ud802\ude47\ud802\ude60\ud802\ude7e\ud802\udf00\ud802\udf35\ud802\udf40\ud802\udf55\ud802\udf58\ud802\udf72\ud802\udf78\ud802\udf7f\ud803\udc00\ud803\udc48\ud803\ude60\ud803\ude7e\ud804\udc00\ud804\udc46\ud804\udc52\ud804\udc6f\ud804\udc80\ud804\udcba\ud808\udc00\ud808\udf6e\ud809\udc00\ud809\udc62\ud80c\udc00\ud80d\udc2e\ud81a\udc00\ud81a\ude38\ud82c\udc00\ud82c\udc01\ud834\udc00\ud834\udcf5\ud834\udd00\ud834\udd26\ud834\udd29\ud834\udd72\ud834\udd7b\ud834\udddd\ud834\ude00\ud834\ude45\ud834\udf00\ud834\udf56\ud834\udf60\ud834\udf71\ud835\udc00\ud835\udc54\ud835\udc56\ud835\udc9c\ud835\udc9e\ud835\udc9f\ud835\udca2\ud835\udca2\ud835\udca5\ud835\udca6\ud835\udca9\ud835\udcac\ud835\udcae\ud835\udcb9\ud835\udcbb\ud835\udcbb\ud835\udcbd\ud835\udcc3\ud835\udcc5\ud835\udd05\ud835\udd07\ud835\udd0a\ud835\udd0d\ud835\udd14\ud835\udd16\ud835\udd1c\ud835\udd1e\ud835\udd39\ud835\udd3b\ud835\udd3e\ud835\udd40\ud835\udd44\ud835\udd46\ud835\udd46\ud835\udd4a\ud835\udd50\ud835\udd52\ud835\udea5\ud835\udea8\ud835\udfcb\ud835\udfce\ud835\udfff\ud83c\udc00\ud83c\udc2b\ud83c\udc30\ud83c\udc93\ud83c\udca0\ud83c\udcae\ud83c\udcb1\ud83c\udcbe\ud83c\udcc1\ud83c\udccf\ud83c\udcd1\ud83c\udcdf\ud83c\udd00\ud83c\udd0a\ud83c\udd10\ud83c\udd2e\ud83c\udd30\ud83c\udd69\ud83c\udd70\ud83c\udd9a\ud83c\udde6\ud83c\ude02\ud83c\ude10\ud83c\ude3a\ud83c\ude40\ud83c\ude48\ud83c\ude50\ud83c\ude51\ud83c\udf00\ud83c\udf20\ud83c\udf30\ud83c\udf35\ud83c\udf37\ud83c\udf7c\ud83c\udf80\ud83c\udf93\ud83c\udfa0\ud83c\udfc4\ud83c\udfc6\ud83c\udfca\ud83c\udfe0\ud83c\udff0\ud83d\udc00\ud83d\udc3e\ud83d\udc40\ud83d\udc40\ud83d\udc42\ud83d\udcf7\ud83d\udcf9\ud83d\udcfc\ud83d\udd00\ud83d\udd3d\ud83d\udd50\ud83d\udd67\ud83d\uddfb\ud83d\uddff\ud83d\ude01\ud83d\ude10\ud83d\ude12\ud83d\ude14\ud83d\ude16\ud83d\ude16\ud83d\ude18\ud83d\ude18\ud83d\ude1a\ud83d\ude1a\ud83d\ude1c\ud83d\ude1e\ud83d\ude20\ud83d\ude25\ud83d\ude28\ud83d\ude2b\ud83d\ude2d\ud83d\ude2d\ud83d\ude30\ud83d\ude33\ud83d\ude35\ud83d\ude40\ud83d\ude45\ud83d\ude4f\ud83d\ude80\ud83d\udec5\ud83d\udf00\ud83d\udf73\ud83f\udffe\ud869\uded6\ud869\udf00\ud86d\udf34\ud86d\udf40\ud86e\udc1d\ud87e\udc00\ud87e\ude1d\ud87f\udffe\ud87f\udfff\ud8bf\udffe\ud8bf\udfff\ud8ff\udffe\ud8ff\udfff\ud93f\udffe\ud93f\udfff\ud97f\udffe\ud97f\udfff\ud9bf\udffe\ud9bf\udfff\ud9ff\udffe\ud9ff\udfff\uda3f\udffe\uda3f\udfff\uda7f\udffe\uda7f\udfff\udabf\udffe\udabf\udfff\udaff\udffe\udaff\udfff\udb3f\udffe\udb3f\udfff\udb40\udd00\udb40\uddef\udb7f\udffe\udb7f\udfff\udbbf\udffe\udbbf\udfff\udbff\udffe\udbff\udfff");
        int[][] letter = Escape.merge(baseChar, ideographic);
        int[][] initialNameChar = Escape.merge(letter, Escape.read("__::"));
        int[][] nameChar = Escape.merge(initialNameChar, digit, Escape.read("-."), combiningChar, extender);
        INITIAL = Escape.serialize(initialNameChar);
        NOT_INITIAL = Escape.serialize(Escape.invert(initialNameChar));
        CHAR = Escape.serialize(nameChar);
        NOT_CHAR = Escape.serialize(Escape.invert(nameChar));
        WORD = Escape.serialize(word);
        NOT_WORD = Escape.serialize(Escape.invert(word));
        HashMap<String, int[][]> m = new HashMap<String, int[][]>();
        Escape.add(m, "BasicLatin", new int[]{0, 127});
        Escape.add(m, "Latin-1Supplement", new int[]{128, 255});
        Escape.add(m, "LatinExtended-A", new int[]{256, 383});
        Escape.add(m, "LatinExtended-B", new int[]{384, 591});
        Escape.add(m, "IPAExtensions", new int[]{592, 687});
        Escape.add(m, "SpacingModifierLetters", new int[]{688, 767});
        Escape.add(m, "CombiningDiacriticalMarks", new int[]{768, 879});
        Escape.add(m, "Greek", new int[]{880, 1023});
        Escape.add(m, "GreekandCoptic", new int[]{880, 1023});
        Escape.add(m, "Cyrillic", new int[]{1024, 1279});
        Escape.add(m, "CyrillicSupplementary", new int[]{1280, 1327});
        Escape.add(m, "CyrillicSupplement", new int[]{1280, 1327});
        Escape.add(m, "Armenian", new int[]{1328, 1423});
        Escape.add(m, "Hebrew", new int[]{1424, 1535});
        Escape.add(m, "Arabic", new int[]{1536, 1791});
        Escape.add(m, "Syriac", new int[]{1792, 1871});
        Escape.add(m, "ArabicSupplement", new int[]{1872, 1919});
        Escape.add(m, "Thaana", new int[]{1920, 1983});
        Escape.add(m, "NKo", new int[]{1984, 2047});
        Escape.add(m, "Samaritan", new int[]{2048, 2111});
        Escape.add(m, "Mandaic", new int[]{2112, 2143});
        Escape.add(m, "Devanagari", new int[]{2304, 2431});
        Escape.add(m, "Bengali", new int[]{2432, 2559});
        Escape.add(m, "Gurmukhi", new int[]{2560, 2687});
        Escape.add(m, "Gujarati", new int[]{2688, 2815});
        Escape.add(m, "Oriya", new int[]{2816, 2943});
        Escape.add(m, "Tamil", new int[]{2944, 3071});
        Escape.add(m, "Telugu", new int[]{3072, 3199});
        Escape.add(m, "Kannada", new int[]{3200, 3327});
        Escape.add(m, "Malayalam", new int[]{3328, 3455});
        Escape.add(m, "Sinhala", new int[]{3456, 3583});
        Escape.add(m, "Thai", new int[]{3584, 3711});
        Escape.add(m, "Lao", new int[]{3712, 3839});
        Escape.add(m, "Tibetan", new int[]{3840, 4031});
        Escape.add(m, "Tibetan", new int[]{3840, 4095});
        Escape.add(m, "Myanmar", new int[]{4096, 4255});
        Escape.add(m, "Georgian", new int[]{4256, 4351});
        Escape.add(m, "HangulJamo", new int[]{4352, 4607});
        Escape.add(m, "Ethiopic", new int[]{4608, 4991});
        Escape.add(m, "EthiopicSupplement", new int[]{4992, 5023});
        Escape.add(m, "Cherokee", new int[]{5024, 5119});
        Escape.add(m, "UnifiedCanadianAboriginalSyllabics", new int[]{5120, 5759});
        Escape.add(m, "Ogham", new int[]{5760, 5791});
        Escape.add(m, "Runic", new int[]{5792, 5887});
        Escape.add(m, "Tagalog", new int[]{5888, 5919});
        Escape.add(m, "Hanunoo", new int[]{5920, 5951});
        Escape.add(m, "Buhid", new int[]{5952, 5983});
        Escape.add(m, "Tagbanwa", new int[]{5984, 6015});
        Escape.add(m, "Khmer", new int[]{6016, 6143});
        Escape.add(m, "Mongolian", new int[]{6144, 6319});
        Escape.add(m, "UnifiedCanadianAboriginalSyllabicsExtended", new int[]{6320, 6399});
        Escape.add(m, "Limbu", new int[]{6400, 6479});
        Escape.add(m, "TaiLe", new int[]{6480, 6527});
        Escape.add(m, "NewTaiLue", new int[]{6528, 6623});
        Escape.add(m, "KhmerSymbols", new int[]{6624, 6655});
        Escape.add(m, "Buginese", new int[]{6656, 6687});
        Escape.add(m, "TaiTham", new int[]{6688, 6831});
        Escape.add(m, "Balinese", new int[]{6912, 7039});
        Escape.add(m, "Sundanese", new int[]{7040, 7103});
        Escape.add(m, "Batak", new int[]{7104, 7167});
        Escape.add(m, "Lepcha", new int[]{7168, 7247});
        Escape.add(m, "OlChiki", new int[]{7248, 7295});
        Escape.add(m, "VedicExtensions", new int[]{7376, 7423});
        Escape.add(m, "PhoneticExtensions", new int[]{7424, 7551});
        Escape.add(m, "PhoneticExtensionsSupplement", new int[]{7552, 7615});
        Escape.add(m, "CombiningDiacriticalMarksSupplement", new int[]{7616, 7679});
        Escape.add(m, "LatinExtendedAdditional", new int[]{7680, 7935});
        Escape.add(m, "GreekExtended", new int[]{7936, 8191});
        Escape.add(m, "GeneralPunctuation", new int[]{8192, 8303});
        Escape.add(m, "SuperscriptsandSubscripts", new int[]{8304, 8351});
        Escape.add(m, "CurrencySymbols", new int[]{8352, 8399});
        Escape.add(m, "CombiningMarksforSymbols", new int[]{8400, 8447});
        Escape.add(m, "CombiningDiacriticalMarksforSymbols", new int[]{8400, 8447});
        Escape.add(m, "LetterlikeSymbols", new int[]{8448, 8527});
        Escape.add(m, "NumberForms", new int[]{8528, 8591});
        Escape.add(m, "Arrows", new int[]{8592, 8703});
        Escape.add(m, "MathematicalOperators", new int[]{8704, 8959});
        Escape.add(m, "MiscellaneousTechnical", new int[]{8960, 9215});
        Escape.add(m, "ControlPictures", new int[]{9216, 9279});
        Escape.add(m, "OpticalCharacterRecognition", new int[]{9280, 9311});
        Escape.add(m, "EnclosedAlphanumerics", new int[]{9312, 9471});
        Escape.add(m, "BoxDrawing", new int[]{9472, 9599});
        Escape.add(m, "BlockElements", new int[]{9600, 9631});
        Escape.add(m, "GeometricShapes", new int[]{9632, 9727});
        Escape.add(m, "MiscellaneousSymbols", new int[]{9728, 9983});
        Escape.add(m, "Dingbats", new int[]{9984, 10175});
        Escape.add(m, "MiscellaneousMathematicalSymbols-A", new int[]{10176, 10223});
        Escape.add(m, "SupplementalArrows-A", new int[]{10224, 10239});
        Escape.add(m, "BraillePatterns", new int[]{10240, 10495});
        Escape.add(m, "SupplementalArrows-B", new int[]{10496, 10623});
        Escape.add(m, "MiscellaneousMathematicalSymbols-B", new int[]{10624, 10751});
        Escape.add(m, "SupplementalMathematicalOperators", new int[]{10752, 11007});
        Escape.add(m, "MiscellaneousSymbolsandArrows", new int[]{11008, 11263});
        Escape.add(m, "Glagolitic", new int[]{11264, 11359});
        Escape.add(m, "LatinExtended-C", new int[]{11360, 11391});
        Escape.add(m, "Coptic", new int[]{11392, 11519});
        Escape.add(m, "GeorgianSupplement", new int[]{11520, 11567});
        Escape.add(m, "Tifinagh", new int[]{11568, 11647});
        Escape.add(m, "EthiopicExtended", new int[]{11648, 11743});
        Escape.add(m, "CyrillicExtended-A", new int[]{11744, 11775});
        Escape.add(m, "SupplementalPunctuation", new int[]{11776, 11903});
        Escape.add(m, "CJKRadicalsSupplement", new int[]{11904, 12031});
        Escape.add(m, "KangxiRadicals", new int[]{12032, 12255});
        Escape.add(m, "IdeographicDescriptionCharacters", new int[]{12272, 12287});
        Escape.add(m, "CJKSymbolsandPunctuation", new int[]{12288, 12351});
        Escape.add(m, "Hiragana", new int[]{12352, 12447});
        Escape.add(m, "Katakana", new int[]{12448, 12543});
        Escape.add(m, "Bopomofo", new int[]{12544, 12591});
        Escape.add(m, "HangulCompatibilityJamo", new int[]{12592, 12687});
        Escape.add(m, "Kanbun", new int[]{12688, 12703});
        Escape.add(m, "BopomofoExtended", new int[]{12704, 12735});
        Escape.add(m, "CJKStrokes", new int[]{12736, 12783});
        Escape.add(m, "KatakanaPhoneticExtensions", new int[]{12784, 12799});
        Escape.add(m, "EnclosedCJKLettersandMonths", new int[]{12800, 13055});
        Escape.add(m, "CJKCompatibility", new int[]{13056, 13311});
        Escape.add(m, "CJKUnifiedIdeographsExtensionA", new int[]{13312, 19893});
        Escape.add(m, "CJKUnifiedIdeographsExtensionA", new int[]{13312, 19903});
        Escape.add(m, "YijingHexagramSymbols", new int[]{19904, 19967});
        Escape.add(m, "CJKUnifiedIdeographs", new int[]{19968, 40959});
        Escape.add(m, "YiSyllables", new int[]{40960, 42127});
        Escape.add(m, "YiRadicals", new int[]{42128, 42191});
        Escape.add(m, "Lisu", new int[]{42192, 42239});
        Escape.add(m, "Vai", new int[]{42240, 42559});
        Escape.add(m, "CyrillicExtended-B", new int[]{42560, 42655});
        Escape.add(m, "Bamum", new int[]{42656, 42751});
        Escape.add(m, "ModifierToneLetters", new int[]{42752, 42783});
        Escape.add(m, "LatinExtended-D", new int[]{42784, 43007});
        Escape.add(m, "SylotiNagri", new int[]{43008, 43055});
        Escape.add(m, "CommonIndicNumberForms", new int[]{43056, 43071});
        Escape.add(m, "Phags-pa", new int[]{43072, 43135});
        Escape.add(m, "Saurashtra", new int[]{43136, 43231});
        Escape.add(m, "DevanagariExtended", new int[]{43232, 43263});
        Escape.add(m, "KayahLi", new int[]{43264, 43311});
        Escape.add(m, "Rejang", new int[]{43312, 43359});
        Escape.add(m, "HangulJamoExtended-A", new int[]{43360, 43391});
        Escape.add(m, "Javanese", new int[]{43392, 43487});
        Escape.add(m, "Cham", new int[]{43520, 43615});
        Escape.add(m, "MyanmarExtended-A", new int[]{43616, 43647});
        Escape.add(m, "TaiViet", new int[]{43648, 43743});
        Escape.add(m, "EthiopicExtended-A", new int[]{43776, 43823});
        Escape.add(m, "MeeteiMayek", new int[]{43968, 44031});
        Escape.add(m, "HangulSyllables", new int[]{44032, 55203});
        Escape.add(m, "HangulSyllables", new int[]{44032, 55215});
        Escape.add(m, "HangulJamoExtended-B", new int[]{55216, 55295});
        Escape.add(m, "HighSurrogates", new int[]{55296, 56191});
        Escape.add(m, "HighPrivateUseSurrogates", new int[]{56192, 56319});
        Escape.add(m, "LowSurrogates", new int[]{56320, 57343});
        Escape.add(m, "PrivateUse", new int[]{57344, 63743});
        Escape.add(m, "PrivateUseArea", new int[]{57344, 63743});
        Escape.add(m, "CJKCompatibilityIdeographs", new int[]{63744, 64255});
        Escape.add(m, "AlphabeticPresentationForms", new int[]{64256, 64335});
        Escape.add(m, "ArabicPresentationForms-A", new int[]{64336, 65023});
        Escape.add(m, "VariationSelectors", new int[]{65024, 65039});
        Escape.add(m, "VerticalForms", new int[]{65040, 65055});
        Escape.add(m, "CombiningHalfMarks", new int[]{65056, 65071});
        Escape.add(m, "CJKCompatibilityForms", new int[]{65072, 65103});
        Escape.add(m, "SmallFormVariants", new int[]{65104, 65135});
        Escape.add(m, "ArabicPresentationForms-B", new int[]{65136, 65278});
        Escape.add(m, "ArabicPresentationForms-B", new int[]{65136, 65279});
        Escape.add(m, "Specials", new int[]{65279, 65279});
        Escape.add(m, "HalfwidthandFullwidthForms", new int[]{65280, 65519});
        Escape.add(m, "Specials", new int[]{65520, 65533});
        Escape.add(m, "Specials", new int[]{65520, 65535});
        Escape.add(m, "LinearBSyllabary", new int[]{65536, 65663});
        Escape.add(m, "LinearBIdeograms", new int[]{65664, 65791});
        Escape.add(m, "AegeanNumbers", new int[]{65792, 65855});
        Escape.add(m, "AncientGreekNumbers", new int[]{65856, 65935});
        Escape.add(m, "AncientSymbols", new int[]{65936, 65999});
        Escape.add(m, "PhaistosDisc", new int[]{66000, 66047});
        Escape.add(m, "Lycian", new int[]{66176, 66207});
        Escape.add(m, "Carian", new int[]{66208, 66271});
        Escape.add(m, "OldItalic", new int[]{66304, 66351});
        Escape.add(m, "Gothic", new int[]{66352, 66383});
        Escape.add(m, "Ugaritic", new int[]{66432, 66463});
        Escape.add(m, "OldPersian", new int[]{66464, 66527});
        Escape.add(m, "Deseret", new int[]{66560, 66639});
        Escape.add(m, "Shavian", new int[]{66640, 66687});
        Escape.add(m, "Osmanya", new int[]{66688, 66735});
        Escape.add(m, "CypriotSyllabary", new int[]{67584, 67647});
        Escape.add(m, "ImperialAramaic", new int[]{67648, 67679});
        Escape.add(m, "Phoenician", new int[]{67840, 67871});
        Escape.add(m, "Lydian", new int[]{67872, 67903});
        Escape.add(m, "Kharoshthi", new int[]{68096, 68191});
        Escape.add(m, "OldSouthArabian", new int[]{68192, 68223});
        Escape.add(m, "Avestan", new int[]{68352, 68415});
        Escape.add(m, "InscriptionalParthian", new int[]{68416, 68447});
        Escape.add(m, "InscriptionalPahlavi", new int[]{68448, 68479});
        Escape.add(m, "OldTurkic", new int[]{68608, 68687});
        Escape.add(m, "RumiNumeralSymbols", new int[]{69216, 69247});
        Escape.add(m, "Brahmi", new int[]{69632, 69759});
        Escape.add(m, "Kaithi", new int[]{69760, 69839});
        Escape.add(m, "Cuneiform", new int[]{73728, 74751});
        Escape.add(m, "CuneiformNumbersandPunctuation", new int[]{74752, 74879});
        Escape.add(m, "EgyptianHieroglyphs", new int[]{77824, 78895});
        Escape.add(m, "BamumSupplement", new int[]{92160, 92735});
        Escape.add(m, "KanaSupplement", new int[]{110592, 110847});
        Escape.add(m, "ByzantineMusicalSymbols", new int[]{118784, 119039});
        Escape.add(m, "MusicalSymbols", new int[]{119040, 119295});
        Escape.add(m, "AncientGreekMusicalNotation", new int[]{119296, 119375});
        Escape.add(m, "TaiXuanJingSymbols", new int[]{119552, 119647});
        Escape.add(m, "CountingRodNumerals", new int[]{119648, 119679});
        Escape.add(m, "MathematicalAlphanumericSymbols", new int[]{119808, 120831});
        Escape.add(m, "MahjongTiles", new int[]{126976, 127023});
        Escape.add(m, "DominoTiles", new int[]{127024, 127135});
        Escape.add(m, "PlayingCards", new int[]{127136, 127231});
        Escape.add(m, "EnclosedAlphanumericSupplement", new int[]{127232, 127487});
        Escape.add(m, "EnclosedIdeographicSupplement", new int[]{127488, 127743});
        Escape.add(m, "MiscellaneousSymbolsAndPictographs", new int[]{127744, 128511});
        Escape.add(m, "Emoticons", new int[]{128512, 128591});
        Escape.add(m, "TransportAndMapSymbols", new int[]{128640, 128767});
        Escape.add(m, "AlchemicalSymbols", new int[]{128768, 128895});
        Escape.add(m, "CJKUnifiedIdeographsExtensionB", new int[]{131072, 173782});
        Escape.add(m, "CJKUnifiedIdeographsExtensionB", new int[]{131072, 173791});
        Escape.add(m, "CJKUnifiedIdeographsExtensionC", new int[]{173824, 177983});
        Escape.add(m, "CJKUnifiedIdeographsExtensionD", new int[]{177984, 178207});
        Escape.add(m, "CJKCompatibilityIdeographsSupplement", new int[]{194560, 195103});
        Escape.add(m, "Tags", new int[]{917504, 917631});
        Escape.add(m, "VariationSelectorsSupplement", new int[]{917760, 917999});
        Escape.add(m, "PrivateUse", new int[]{983040, 1048573});
        Escape.add(m, "SupplementaryPrivateUseArea-A", new int[]{983040, 1048575});
        Escape.add(m, "PrivateUse", new int[]{0x100000, 1114109});
        Escape.add(m, "SupplementaryPrivateUseArea-B", new int[]{0x100000, 0x10FFFF});
        m.forEach((key, vals) -> {
            int vl = ((int[][])vals).length;
            CharRange[] rs = new CharRange[vl];
            for (int v = 0; v < vl; ++v) {
                rs[v] = new CharRange(vals[v][0], vals[v][1]);
            }
            MAP.put("\\p{Is" + key + '}', rs);
            int[][] not = Escape.invert(vals);
            int nl = not.length;
            CharRange[] nrs = new CharRange[nl];
            for (int n = 0; n < nl; ++n) {
                nrs[n] = new CharRange(not[n][0], not[n][1]);
            }
            MAP.put("\\P{Is" + key + '}', nrs);
        });
    }
}

