/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.list;

import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.util.list.ObjectList;

public final class AnnList
extends ObjectList<Ann, AnnList> {
    public AnnList() {
        super(new Ann[0]);
    }

    @Override
    public boolean contains(Annotation sig) {
        return this.get(sig) != null;
    }

    public Ann get(Annotation sig) {
        for (Ann ann : this) {
            if (ann.sig != sig) continue;
            return ann;
        }
        return null;
    }

    public AnnList intersect(AnnList anns) {
        Annotation sig;
        AnnList tmp = new AnnList();
        boolean pub = false;
        boolean priv = false;
        boolean up = false;
        for (Ann ann : this) {
            sig = ann.sig;
            if (sig == Annotation.PUBLIC) {
                pub = true;
            } else if (sig == Annotation.PRIVATE) {
                priv = true;
            } else if (sig == Annotation.UPDATING) {
                up = true;
            }
            tmp.add(ann);
        }
        for (Ann ann : anns) {
            sig = ann.sig;
            if (sig == Annotation.PUBLIC) {
                if (pub) continue;
                if (priv) {
                    return null;
                }
            } else if (sig == Annotation.PRIVATE) {
                if (pub) {
                    return null;
                }
                if (priv) {
                    continue;
                }
            } else if (sig == Annotation.UPDATING && up) continue;
            tmp.add(ann);
        }
        return tmp;
    }

    public AnnList union(AnnList anns) {
        AnnList tmp = new AnnList();
        for (Ann ann : this) {
            for (Ann ann2 : anns) {
                if (!ann.equals(ann2)) continue;
                tmp.add(ann);
            }
        }
        return tmp;
    }

    public AnnList check(boolean variable, boolean visible) throws QueryException {
        boolean up = false;
        boolean vis = false;
        for (Ann ann : this) {
            Annotation sig = ann.sig;
            if (sig == Annotation.UPDATING) {
                if (up) {
                    throw QueryError.DUPLUPD.get(ann.info, new Object[0]);
                }
                up = true;
                continue;
            }
            if (!visible || sig != Annotation.PUBLIC && sig != Annotation.PRIVATE) continue;
            if (vis) {
                throw (variable ? QueryError.DUPLVARVIS : QueryError.DUPLFUNVIS).get(ann.info, new Object[0]);
            }
            vis = true;
        }
        return this;
    }

    protected Ann[] newArray(int s) {
        return new Ann[s];
    }

    public void plan(QueryString qs) {
        for (Ann ann : this) {
            ann.plan(qs);
        }
    }
}

