/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives.db;

import org.basex.data.Data;
import org.basex.data.DataClip;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.DBNew;
import org.basex.query.up.primitives.DBOptions;
import org.basex.query.up.primitives.NewInput;
import org.basex.query.up.primitives.Update;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.db.DBUpdate;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.options.Options;

public final class DBAdd
extends DBUpdate {
    private final DBNew newDocs;
    private final boolean replace;
    private DataClip clip;
    private int size;

    public DBAdd(Data data, NewInput input, Options opts, boolean replace, QueryContext qc, InputInfo info) throws QueryException {
        super(UpdateType.DBADD, data, info);
        this.replace = replace;
        DBOptions options = new DBOptions(opts, DBOptions.PARSING, info);
        this.newDocs = new DBNew(qc, options, info, input);
    }

    @Override
    public void prepare() throws QueryException {
        this.size = this.newDocs.inputs.size();
        this.clip = this.newDocs.prepare(this.data.meta.name, false);
    }

    @Override
    public void apply() throws QueryException {
        try {
            this.newDocs.addTo(this.data);
        }
        finally {
            this.clip.finish();
        }
    }

    @Override
    public void merge(Update update) throws QueryException {
        DBAdd add = (DBAdd)update;
        if (this.replace || add.replace) {
            NewInput input = this.newDocs.inputs.get(0);
            NewInput addInput = add.newDocs.inputs.get(0);
            String path = input.path;
            String addPath = addInput.path;
            if (input.io != null) {
                path = path + '/' + input.io.name();
            }
            if (addInput.io != null) {
                addPath = addPath + '/' + addInput.io.name();
            }
            if (path.equals(addPath)) {
                throw QueryError.UPMULTDOC_X_X.get(this.info, this.data.meta.name, addPath);
            }
        }
        this.newDocs.merge(add.newDocs);
    }

    @Override
    public int size() {
        return this.size;
    }

    public String toString() {
        return Util.className(this) + '[' + this.newDocs.inputs + ']';
    }
}

