/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.expr;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.constr.Constr;
import org.basex.query.iter.Iter;
import org.basex.query.up.Updates;
import org.basex.query.up.expr.Update;
import org.basex.query.up.primitives.node.InsertAfter;
import org.basex.query.up.primitives.node.InsertAttribute;
import org.basex.query.up.primitives.node.InsertBefore;
import org.basex.query.up.primitives.node.InsertInto;
import org.basex.query.up.primitives.node.InsertIntoAsFirst;
import org.basex.query.up.primitives.node.InsertIntoAsLast;
import org.basex.query.up.primitives.node.NodeCopy;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.NodeType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class Insert
extends Update {
    private final Mode mode;

    public Insert(StaticContext sc, InputInfo info, Expr src, Mode mode, Expr trg) {
        super(sc, info, trg, src);
        this.mode = mode;
    }

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        NodeCopy up;
        DBNode dbn;
        boolean loc;
        Constr c = new Constr(this.info, this.sc).add(qc, this.exprs[1]);
        ANodeList cList = c.children;
        ANodeList aList = c.atts;
        if (c.errAtt != null) {
            throw QueryError.UPNOATTRPER_X.get(this.info, c.errAtt);
        }
        if (c.duplAtt != null) {
            throw QueryError.UPATTDUPL_X.get(this.info, c.duplAtt);
        }
        Iter iter = this.exprs[0].iter(qc);
        Item item = iter.next();
        if (item == null) {
            throw QueryError.UPSEQEMP_X.get(this.info, Util.className(this));
        }
        boolean bl = loc = this.mode == Mode.BEFORE || this.mode == Mode.AFTER;
        if (!(item instanceof ANode)) {
            throw (loc ? QueryError.UPTRGTYP2_X : QueryError.UPTRGTYP_X).get(this.info, item);
        }
        Item i2 = iter.next();
        if (i2 != null) {
            throw (loc ? QueryError.UPTRGSNGL2_X : QueryError.UPTRGSNGL_X).get(this.info, ValueBuilder.concat(item, i2, qc));
        }
        ANode node = (ANode)item;
        ANode parent = node.parent();
        if (loc) {
            if (node.type.oneOf(NodeType.ATTRIBUTE, NodeType.DOCUMENT_NODE)) {
                throw QueryError.UPTRGTYP2_X.get(this.info, node);
            }
            if (parent == null) {
                throw QueryError.UPPAREMPTY_X.get(this.info, node);
            }
        } else if (!node.type.oneOf(NodeType.ELEMENT, NodeType.DOCUMENT_NODE)) {
            throw QueryError.UPTRGTYP_X.get(this.info, node);
        }
        Updates updates = qc.updates();
        if (!aList.isEmpty()) {
            ANode targ;
            ANode aNode = targ = loc ? parent : node;
            if (targ.type != NodeType.ELEMENT) {
                throw (loc ? QueryError.UPATTELM_X : QueryError.UPATTELM2_X).get(this.info, targ);
            }
            dbn = updates.determineDataRef(targ, qc);
            up = new InsertAttribute(dbn.pre(), dbn.data(), this.info, this.checkNS(aList, targ));
            updates.add(up, qc);
        }
        if (!cList.isEmpty()) {
            dbn = updates.determineDataRef(node, qc);
            switch (this.mode) {
                case BEFORE: {
                    up = new InsertBefore(dbn.pre(), dbn.data(), this.info, cList);
                    break;
                }
                case AFTER: {
                    up = new InsertAfter(dbn.pre(), dbn.data(), this.info, cList);
                    break;
                }
                case FIRST: {
                    up = new InsertIntoAsFirst(dbn.pre(), dbn.data(), this.info, cList);
                    break;
                }
                case LAST: {
                    up = new InsertIntoAsLast(dbn.pre(), dbn.data(), this.info, cList);
                    break;
                }
                default: {
                    up = new InsertInto(dbn.pre(), dbn.data(), this.info, cList);
                }
            }
            updates.add(up, qc);
        }
        return Empty.VALUE;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new Insert(this.sc, this.info, this.exprs[1].copy(cc, vm), this.mode, this.exprs[0].copy(cc, vm)));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Insert && this.mode == ((Insert)obj).mode && super.equals(obj);
    }

    @Override
    public void plan(QueryString qs) {
        qs.token("insert").token("nodes").token(this.exprs[1]).token("into").token(this.exprs[0]);
    }

    public static enum Mode {
        INTO,
        FIRST,
        LAST,
        BEFORE,
        AFTER;

    }
}

