/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up;

import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Array;
import org.basex.util.Atts;
import org.basex.util.Token;

public final class NamePool {
    private NameCache[] cache = new NameCache[1];
    private int size;

    public void add(QNm name, NodeType type) {
        if (type != NodeType.ATTRIBUTE && type != NodeType.ELEMENT) {
            return;
        }
        int i = this.index(name, type == NodeType.ATTRIBUTE);
        this.cache[i].add++;
    }

    public void remove(ANode node) {
        if (node.type != NodeType.ATTRIBUTE && node.type != NodeType.ELEMENT) {
            return;
        }
        int i = this.index(node.qname(), node.type == NodeType.ATTRIBUTE);
        this.cache[i].del = true;
    }

    QNm duplicate() {
        for (int i = 0; i < this.size; ++i) {
            NameCache nc = this.cache[i];
            if (!nc.attr || nc.add <= (nc.del ? 2 : 1)) continue;
            return nc.name;
        }
        return null;
    }

    byte[][] nsOK() {
        Atts at = new Atts();
        for (int i = 0; i < this.size; ++i) {
            NameCache nc = this.cache[i];
            if (nc.add <= (nc.del ? 1 : 0)) continue;
            QNm nm = nc.name;
            byte[] pref = nm.prefix();
            byte[] uri = nm.uri();
            if (nc.attr && uri.length == 0) continue;
            byte[] u = at.value(pref);
            if (u == null) {
                at.add(pref, uri);
                continue;
            }
            if (Token.eq(uri, u)) continue;
            return new byte[][]{uri, u};
        }
        return null;
    }

    private int index(QNm name, boolean at) {
        for (int i = 0; i < this.size; ++i) {
            NameCache nc = this.cache[i];
            if (!nc.name.eq(name) || nc.attr != at) continue;
            return i;
        }
        if (this.size == this.cache.length) {
            this.cache = Array.copy(this.cache, new NameCache[Array.newCapacity(this.size)]);
        }
        NameCache nc = new NameCache();
        nc.name = name;
        nc.attr = at;
        this.cache[this.size] = nc;
        return this.size++;
    }

    private static final class NameCache {
        private QNm name;
        private boolean attr;
        private int add;
        private boolean del;

        private NameCache() {
        }
    }
}

