/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.web;

import java.util.HashMap;
import org.basex.io.serial.SerializerMode;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.func.FuncOptions;
import org.basex.query.func.StandardFunc;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.node.FElem;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.options.NumberOption;
import org.basex.util.options.Option;
import org.basex.util.options.Options;
import org.basex.util.options.StringOption;

abstract class WebFn
extends StandardFunc {
    WebFn() {
    }

    final String createUrl(QueryContext qc) throws QueryException {
        byte[] path = this.toToken(this.exprs[0], qc);
        XQMap map = this.exprs.length < 2 ? XQMap.EMPTY : this.toMap(this.exprs[1], qc);
        byte[] anchor = this.exprs.length < 3 ? Token.EMPTY : this.toToken(this.exprs[2], qc);
        TokenBuilder tb = new TokenBuilder().add(path);
        int c = 0;
        for (Item key : map.keys()) {
            byte[] name = key.string(this.info);
            for (Item value : map.get(key, this.info)) {
                tb.add(c++ == 0 ? 63 : 38).add(Token.encodeUri(name, false));
                tb.add(61).add(Token.encodeUri(value.string(this.info), false));
            }
        }
        if (anchor.length > 0) {
            tb.add(35).add(Token.encodeUri(anchor, false));
        }
        return tb.toString();
    }

    final FElem createResponse(ResponseOptions response, HashMap<String, String> headers, HashMap<String, String> output) throws QueryException {
        FElem rrest = new FElem(new QNm(QueryText.REST_PREFIX, "response", QueryText.REST_URI)).declareNS();
        FElem hresp = new FElem(new QNm(QueryText.HTTP_PREFIX, "response", QueryText.HTTP_URI)).declareNS();
        for (Option<?> o : response) {
            if (!response.contains(o)) continue;
            hresp.add(o.name(), response.get(o).toString());
        }
        headers.forEach((name, value) -> {
            if (!value.isEmpty()) {
                hresp.add(new FElem(new QNm(QueryText.HTTP_PREFIX, "header", QueryText.HTTP_URI)).add("name", (String)name).add("value", (String)value));
            }
        });
        rrest.add(hresp);
        if (output != null) {
            SerializerOptions so = SerializerMode.DEFAULT.get();
            for (String entry : output.keySet()) {
                if (so.option(entry) != null) continue;
                throw QueryError.INVALIDOPTION_X.get(this.info, entry);
            }
            FElem oseri = new FElem(FuncOptions.Q_SPARAM).declareNS();
            output.forEach((name, value) -> {
                if (!value.isEmpty()) {
                    oseri.add(new FElem(new QNm(QueryText.OUTPUT_PREFIX, (String)name, QueryText.OUTPUT_URI)).add("value", (String)value));
                }
            });
            rrest.add(oseri);
        }
        return rrest;
    }

    public static class ResponseOptions
    extends Options {
        public static final NumberOption STATUS = new NumberOption("status");
        public static final StringOption MESSAGE = new StringOption("message");
    }
}

