/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.util;

import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.file.FileReadTextLines;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

public final class UtilItem
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        long pos = this.pos(qc);
        if (pos < 0L) {
            return Empty.VALUE;
        }
        Expr expr = this.exprs[0];
        if (expr.seqType().zeroOrOne()) {
            return pos == 0L ? expr.item(qc, this.info) : Empty.VALUE;
        }
        Iter iter = expr.iter(qc);
        long size = iter.size();
        if (size >= 0L) {
            return pos < size ? iter.get(pos) : Empty.VALUE;
        }
        long p = pos;
        while ((item = qc.next(iter)) != null) {
            if (p-- != 0L) continue;
            return item;
        }
        return Empty.VALUE;
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr expr = this.exprs[0];
        Expr position = this.exprs[1];
        SeqType st = expr.seqType();
        if (st.zero()) {
            return expr;
        }
        if (position instanceof Value) {
            Expr[] args;
            long pos = this.pos(cc.qc);
            if (pos < 0L) {
                return Empty.VALUE;
            }
            if (st.zeroOrOne()) {
                return pos == 0L ? expr : Empty.VALUE;
            }
            long size = expr.size();
            if (size != -1L) {
                if (pos + 1L == size) {
                    return cc.function(Function._UTIL_LAST, this.info, expr);
                }
                if (pos + 1L > size) {
                    return Empty.VALUE;
                }
                if (Function.REVERSE.is(expr)) {
                    return cc.function(Function._UTIL_ITEM, this.info, expr.arg(0), Int.get(size - pos));
                }
            }
            if (pos == 0L) {
                return cc.function(Function.HEAD, this.info, expr);
            }
            if (Function.TAIL.is(expr)) {
                return cc.function(Function._UTIL_ITEM, this.info, expr.arg(0), Int.get(pos + 2L));
            }
            if (Function._UTIL_REPLICATE.is(expr) && (args = expr.args())[0].size() == 1L && args[1] instanceof Int) {
                long count = ((Int)args[1]).itr();
                return pos > count ? Empty.VALUE : args[0];
            }
            if (Function._FILE_READ_TEXT_LINES.is(expr)) {
                return FileReadTextLines.opt(this, pos, 1L, cc);
            }
            if (expr instanceof List) {
                args = expr.args();
                int al = args.length;
                for (int a = 0; a < al; ++a) {
                    if ((long)a == pos) {
                        Expr list = List.get(cc, this.info, Arrays.copyOfRange(args, a, al));
                        return cc.function(Function.HEAD, this.info, list);
                    }
                    if (!args[a].seqType().one()) break;
                }
            }
        }
        if (Function._UTIL_INIT.is(expr)) {
            return cc.function(Function._UTIL_ITEM, this.info, expr.arg(0), position);
        }
        this.exprType.assign(st.with(Occ.ZERO_OR_ONE));
        this.data(expr.data());
        return this;
    }

    private long pos(QueryContext qc) throws QueryException {
        long pos;
        double dp = this.toDouble(this.exprs[1], qc);
        return dp != (double)(pos = (long)dp) ? -1L : pos - 1L;
    }
}

