/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.util;

import java.util.Iterator;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.Occ;

public final class UtilArrayValues
extends StandardFunc {
    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        final XQArray array = this.toArray(this.exprs[0], qc);
        return new Iter(){
            final Iterator<Value> members;
            Iter ir;
            {
                this.members = array.members().iterator();
            }

            @Override
            public Item next() throws QueryException {
                Item item;
                while (this.ir == null || (item = qc.next(this.ir)) == null) {
                    if (!this.members.hasNext()) {
                        return null;
                    }
                    this.ir = this.members.next().iter();
                }
                return item;
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        XQArray array = this.toArray(this.exprs[0], qc);
        ValueBuilder vb = new ValueBuilder(qc);
        for (Value member : array.members()) {
            vb.add(member);
        }
        return vb.value(this);
    }

    @Override
    protected Expr opt(CompileContext cc) {
        FuncType ft = this.exprs[0].funcType();
        if (ft instanceof ArrayType) {
            this.exprType.assign(ft.declType.with(Occ.ZERO_OR_MORE));
        }
        return this;
    }
}

