/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.user;

import java.util.ArrayList;
import org.basex.core.users.Perm;
import org.basex.core.users.User;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.user.UserFn;
import org.basex.query.up.primitives.UpdateType;
import org.basex.query.up.primitives.UserPermUpdate;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.list.StringList;

public final class UserCreate
extends UserFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        this.checkAdmin(qc);
        String name = this.toSafeName(0, qc);
        String pw = this.toString(1, qc);
        ArrayList<Perm> perms = this.toPerms(2, qc);
        StringList patterns = this.toPatterns(3, qc);
        User user = new User(name, pw);
        if (name.equals("admin")) {
            throw QueryError.USER_ADMIN.get(this.info, new Object[0]);
        }
        if (this.exprs.length > 4) {
            ANode node = this.toElem(this.exprs[4], qc);
            if (!T_INFO.matches(node)) {
                throw QueryError.ELM_X_X.get(this.info, Q_INFO.prefixId(), node);
            }
            user.info(node.materialize(qc, true));
        }
        qc.updates().add(new Create(user, perms, patterns, qc, this.info), qc);
        return Empty.VALUE;
    }

    private static final class Create
    extends UserPermUpdate {
        private Create(User user, ArrayList<Perm> perms, StringList patterns, QueryContext qc, InputInfo info) throws QueryException {
            super(UpdateType.USERCREATE, user, perms, patterns, qc, info);
        }

        @Override
        public void apply() {
            User olduser = this.users.get(this.user.name());
            if (olduser != null) {
                this.users.drop(olduser);
            }
            this.users.add(this.user);
            this.grant();
        }

        @Override
        public String operation() {
            return "created";
        }
    }
}

