/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.java;

import java.lang.reflect.Method;
import org.basex.core.users.Perm;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.java.JavaCall;
import org.basex.query.func.java.JavaEval;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.var.Var;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class StaticJavaCall
extends JavaCall {
    private final Object module;
    private final Method method;
    private final Class<?>[] params;
    private final boolean[] values;

    StaticJavaCall(Object module, Method method, Expr[] args, Perm perm, boolean updating, StaticContext sc, InputInfo info) {
        super(args, perm, updating, sc, info);
        this.module = module;
        this.method = method;
        this.params = method.getParameterTypes();
        int pl = this.params.length;
        this.values = new boolean[pl];
        for (int p = 0; p < pl; ++p) {
            this.values[p] = Value.class.isAssignableFrom(this.params[p]);
        }
    }

    @Override
    public boolean vacuous() {
        return this.method.getReturnType() == Void.TYPE;
    }

    @Override
    protected Object eval(QueryContext qc) throws QueryException {
        JavaEval je = new JavaEval(this, qc);
        if (je.match(this.params, true, this.values)) {
            if (this.module instanceof QueryModule) {
                QueryModule qm = (QueryModule)this.module;
                qm.staticContext = this.sc;
                qm.queryContext = qc;
            }
            try {
                return this.method.invoke(this.module, je.args);
            }
            catch (Throwable th) {
                throw je.execError(th);
            }
        }
        throw je.argsError(this.method, false);
    }

    @Override
    public StaticJavaCall copy(CompileContext cc, IntObjMap<Var> vm) {
        return this.copyType(new StaticJavaCall(this.module, this.method, StaticJavaCall.copyAll((CompileContext)cc, vm, (Expr[])this.exprs), this.perm, this.updating, this.sc, this.info));
    }

    @Override
    public boolean has(Flag ... flags) {
        return Flag.UPD.in(flags) && this.method.getAnnotation(QueryModule.Updating.class) != null || Flag.NDT.in(flags) && this.method.getAnnotation(QueryModule.Deterministic.class) == null || (Flag.CTX.in(flags) || Flag.POS.in(flags)) && this.method.getAnnotation(QueryModule.FocusDependent.class) != null || super.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        return (ic.var != null || this.method.getAnnotation(QueryModule.FocusDependent.class) == null) && super.inlineable(ic);
    }

    @Override
    String desc() {
        return this.name();
    }

    @Override
    String name() {
        return Util.className(this.module) + ":" + this.method.getName();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StaticJavaCall)) {
            return false;
        }
        StaticJavaCall j = (StaticJavaCall)obj;
        return this.module.equals(j.module) && this.method.equals(j.method) && Array.equals(this.params, j.params) && super.equals(obj);
    }
}

