/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.java;

import java.lang.reflect.Executable;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.java.DynJavaCall;
import org.basex.query.func.java.JavaCall;
import org.basex.query.func.java.JavaMapping;
import org.basex.query.value.Value;
import org.basex.query.value.item.Jav;
import org.basex.query.value.type.Type;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

final class JavaEval {
    private final JavaCall call;
    private final QueryContext qc;
    private final Class<?> clazz;
    Expr[] exprs;
    Object[] args = new Object[0];

    JavaEval(JavaCall call, QueryContext qc) {
        this(call, qc, null);
    }

    JavaEval(DynJavaCall call, QueryContext qc) {
        this(call, qc, call.clazz);
    }

    private JavaEval(JavaCall call, QueryContext qc, Class<?> clazz) {
        this.call = call;
        this.qc = qc;
        this.clazz = clazz;
        this.exprs = (Expr[])call.exprs.clone();
    }

    Object classInstance(boolean stat) throws QueryException {
        if (stat) {
            return null;
        }
        Value value = this.exprs[0].value(this.qc);
        this.exprs[0] = value;
        return this.clazz.isInstance(value) ? value : value.toJava();
    }

    boolean match(Class<?>[] params, boolean stat, boolean[] values) throws QueryException {
        int pl = params.length;
        int s = stat ? 0 : 1;
        if (pl != this.exprs.length - s) {
            return false;
        }
        Object[] vals = new Object[pl];
        for (int p = 0; p < pl; ++p) {
            Class<?> param = params[p];
            Expr expr = this.exprs[s + p];
            if (param == Expr.class) {
                vals[p] = expr;
                continue;
            }
            Value arg = expr.value(this.qc);
            this.exprs[s + p] = arg;
            Type type = JavaMapping.type(param, true);
            if (type != null && arg.type.instanceOf(type)) {
                vals[p] = arg.toJava();
                continue;
            }
            boolean java = arg instanceof Jav || !(values == null ? Value.class.isAssignableFrom(params[p]) : values[p]);
            Object object = vals[p] = java ? arg.toJava() : arg;
            if (param.isInstance(vals[p])) continue;
            if (arg.isEmpty() && !param.isPrimitive()) {
                vals[p] = null;
                continue;
            }
            return false;
        }
        this.args = vals;
        return true;
    }

    QueryException instanceError(IllegalArgumentException ex) {
        Util.debug(ex);
        return QueryError.JAVAINVOKE_X_X.get(this.call.info, this.clazz.getName(), JavaEval.type(this.exprs[0]));
    }

    QueryException execError(Throwable th) {
        Throwable root = Util.rootException(th);
        if (root instanceof QueryException) {
            return ((QueryException)root).info(this.call.info);
        }
        return QueryError.JAVAEVAL_X_X_X.get(this.call.info, root, this.call.name(), JavaEval.types(this.args));
    }

    QueryException argsError(Executable exec, boolean multiple) {
        if (multiple) {
            return QueryError.DYNARGS_X_X.get(this.call.info, this.call.name(), JavaEval.types(this.exprs));
        }
        TokenBuilder expect = new TokenBuilder();
        for (Class<?> param : exec.getParameterTypes()) {
            Type type;
            if (!expect.isEmpty()) {
                expect.add(", ");
            }
            expect.add((type = JavaMapping.type(param, false)) != null ? type : Util.className(param));
        }
        return QueryError.JAVAARGS_X_X_X.get(this.call.info, this.call.name(), expect, JavaEval.types(this.exprs));
    }

    QueryException multipleError(QueryError error) {
        return error.get(this.call.info, this.call.name(), this.exprs.length);
    }

    private static String types(Object[] args) {
        TokenBuilder tb = new TokenBuilder();
        for (Object arg : args) {
            if (!tb.isEmpty()) {
                tb.add(", ");
            }
            tb.add(JavaEval.type(arg));
        }
        return tb.toString();
    }

    private static String type(Object arg) {
        return arg == null ? Util.info(null, new Object[0]) : (arg instanceof Jav ? Util.className(((Jav)arg).toJava()) : (arg instanceof Value ? ((Value)arg).seqType().toString() : Util.className(arg)));
    }
}

