/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.java;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryModule;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.func.java.DynJavaCall;
import org.basex.query.func.java.JavaCall;
import org.basex.query.func.java.JavaEval;
import org.basex.query.value.item.Jav;
import org.basex.query.value.item.QNm;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

final class DynJavaFunc
extends DynJavaCall {
    private final String name;
    public ArrayList<Method> methods;
    public Field field;

    DynJavaFunc(Class<?> clazz, String name, String[] types, Expr[] args, StaticContext sc, InputInfo info) {
        super(clazz, types, args, sc, info);
        this.name = name;
    }

    public boolean init(boolean enforce) throws QueryException {
        int arity = this.exprs.length;
        IntList arities = new IntList();
        try {
            int al;
            Method[] f = this.clazz.getField(this.name);
            int n = al = DynJavaFunc.isStatic((Field)f) ? 0 : 1;
            if (arity == al) {
                this.field = f;
            } else {
                arities.add(al);
            }
        }
        catch (NoSuchFieldException f) {
            // empty catch block
        }
        this.methods = new ArrayList();
        for (Method m : this.clazz.getMethods()) {
            if (!m.getName().equals(this.name)) continue;
            Class<?>[] classArray = m.getParameterTypes();
            int al = classArray.length + (DynJavaFunc.isStatic(m) ? 0 : 1);
            if (al == arity) {
                if (!DynJavaFunc.typesMatch(classArray, this.types)) continue;
                this.methods.add(m);
                continue;
            }
            if (this.types != null) continue;
            arities.add(al);
        }
        if (this.field != null || !this.methods.isEmpty()) {
            return true;
        }
        if (!enforce) {
            return false;
        }
        TokenList names = new TokenList();
        for (Method method : this.clazz.getMethods()) {
            names.add(method.getName());
        }
        for (AccessibleObject accessibleObject : this.clazz.getFields()) {
            names.add(((Field)accessibleObject).getName());
        }
        throw DynJavaFunc.noFunction(this.name, arity, this.name(), arities, this.types, this.info, (byte[][])names.finish());
    }

    @Override
    protected Object eval(QueryContext qc) throws QueryException {
        Object value = this.field(qc);
        return value != null ? value : this.method(qc);
    }

    private Object field(QueryContext qc) throws QueryException {
        if (this.field == null) {
            return null;
        }
        JavaEval je = new JavaEval(this, qc);
        Object instance = je.classInstance(DynJavaFunc.isStatic(this.field));
        try {
            return this.field.get(instance);
        }
        catch (IllegalArgumentException ex) {
            throw je.instanceError(ex);
        }
        catch (Throwable th) {
            throw je.execError(th);
        }
    }

    private Object method(QueryContext qc) throws QueryException {
        boolean multiple;
        JavaEval je = new JavaEval(this, qc);
        Method method = null;
        for (Method m : this.methods) {
            if (!je.match(m.getParameterTypes(), DynJavaFunc.isStatic(m), null)) continue;
            if (method != null) {
                throw je.multipleError(QueryError.DYNMULTIFUNC_X_X);
            }
            method = m;
        }
        if (method != null) {
            Object instance = je.classInstance(DynJavaFunc.isStatic(method));
            if (instance instanceof QueryModule) {
                QueryModule qm = (QueryModule)instance;
                qm.staticContext = this.sc;
                qm.queryContext = qc;
            }
            try {
                return method.invoke(instance, je.args);
            }
            catch (IllegalArgumentException ex) {
                throw je.instanceError(ex);
            }
            catch (Throwable th) {
                throw je.execError(th);
            }
        }
        method = this.methods.get(0);
        Expr[] ex = je.exprs;
        boolean bl = multiple = this.methods.size() > 1;
        if (!multiple && !DynJavaFunc.isStatic(method) || ex.length > 0 && (ex[0] instanceof Jav || ex[0] instanceof JavaCall)) {
            je.exprs = Arrays.copyOfRange(ex, 1, ex.length);
        }
        throw je.argsError(method, multiple);
    }

    private static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    private static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        DynJavaFunc f = new DynJavaFunc(this.clazz, this.name, this.types, DynJavaFunc.copyAll((CompileContext)cc, vm, (Expr[])this.exprs), this.sc, this.info);
        f.field = this.field;
        f.methods = this.methods;
        return this.copyType(f);
    }

    @Override
    String desc() {
        return QNm.eqName("java:" + this.clazz.getName(), this.name);
    }

    @Override
    String name() {
        return this.clazz.getName() + ":" + this.name;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof DynJavaFunc && this.name.equals(((DynJavaFunc)obj).name) && super.equals(obj);
    }
}

