/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.index;

import org.basex.data.Data;
import org.basex.index.name.Names;
import org.basex.index.path.PathNode;
import org.basex.index.stats.Stats;
import org.basex.index.stats.StatsType;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.index.IndexFn;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class IndexFacets
extends IndexFn {
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String MIN = "min";
    private static final String MAX = "max";
    private static final byte[] ELM = NodeType.ELEMENT.qname().local();
    private static final byte[] ATT = NodeType.ATTRIBUTE.qname().local();
    private static final byte[] FLAT = Token.token("flat");

    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Data data = this.checkData(qc);
        boolean flat = this.exprs.length == 2 && Token.eq(this.toToken(this.exprs[1], qc), FLAT);
        return new FDoc().add(flat ? IndexFacets.flat(data) : IndexFacets.tree(data, data.paths.root().get(0)));
    }

    private static FElem flat(Data data) {
        FElem elem = new FElem(NodeType.DOCUMENT_NODE.qname());
        IndexFacets.index(data.elemNames, ELM, elem);
        IndexFacets.index(data.attrNames, ATT, elem);
        return elem;
    }

    private static FElem tree(Data data, PathNode root) {
        Names names;
        FElem elem = new FElem(ANode.type(root.kind).qname());
        boolean elm = root.kind == 1;
        Names names2 = names = elm ? data.elemNames : data.attrNames;
        if (root.kind == 3 || elm) {
            elem.add(NAME, names.key(root.name));
        }
        IndexFacets.stats(root.stats, elem);
        for (PathNode p : root.children) {
            elem.add(IndexFacets.tree(data, p));
        }
        return elem;
    }

    private static void index(Names names, byte[] name, FElem root) {
        int ns = names.size();
        for (int n = 1; n <= ns; ++n) {
            FElem sub = new FElem(name).add(NAME, names.key(n));
            IndexFacets.stats(names.stats(n), sub);
            root.add(sub);
        }
    }

    private static void stats(Stats stats, FElem elem) {
        byte type = stats.type;
        if (!StatsType.isNone(type)) {
            elem.add(TYPE, StatsType.toString(type));
        }
        elem.add("count", Token.token(stats.count));
        if (StatsType.isInteger(type) || StatsType.isDouble(type)) {
            int mn = (int)stats.min;
            int mx = (int)stats.max;
            elem.add(MIN, (double)mn == stats.min ? Token.token(mn) : Token.token(stats.min));
            elem.add(MAX, (double)mx == stats.max ? Token.token(mx) : Token.token(stats.max));
        }
        if (StatsType.isCategory(type)) {
            for (byte[] value : stats.values) {
                elem.add(new FElem("entry").add("count", Token.token(stats.values.get(value))).add(value));
            }
        }
    }
}

