/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.func.file.FileReadTextLines;
import org.basex.query.func.fn.SeqRange;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;

public final class FnTail
extends StandardFunc {
    @Override
    public Iter iter(final QueryContext qc) throws QueryException {
        final Iter iter = this.exprs[0].iter(qc);
        final long size = iter.size();
        if (size == 0L || size == 1L || iter.next() == null) {
            return Empty.ITER;
        }
        Value value = iter.iterValue();
        if (value != null) {
            return value.subsequence(1L, size - 1L, qc).iter();
        }
        if (size > 1L) {
            return new Iter(){

                @Override
                public Item next() throws QueryException {
                    return qc.next(iter);
                }

                @Override
                public Item get(long i) throws QueryException {
                    return iter.get(i + 1L);
                }

                @Override
                public long size() {
                    return size - 1L;
                }
            };
        }
        return new Iter(){

            @Override
            public Item next() throws QueryException {
                return qc.next(iter);
            }
        };
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        Value value = this.exprs[0].value(qc);
        long size = value.size();
        return size <= 1L ? Empty.VALUE : value.subsequence(1L, size - 1L, qc);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr first;
        Expr[] args;
        SeqRange r;
        Expr expr = this.exprs[0];
        if (expr instanceof Value) {
            return this.value(cc.qc);
        }
        long size = expr.size();
        SeqType st = expr.seqType();
        if (size == 0L || size == 1L || st.zeroOrOne()) {
            return Empty.VALUE;
        }
        if (size == 2L) {
            return cc.function(Function._UTIL_LAST, this.info, expr);
        }
        if (Function.TAIL.is(expr)) {
            return cc.function(Function.SUBSEQUENCE, this.info, expr.arg(0), Int.get(3L));
        }
        if ((Function.SUBSEQUENCE.is(expr) || Function._UTIL_RANGE.is(expr)) && (r = SeqRange.get(expr, cc)) != null) {
            return cc.function(Function.SUBSEQUENCE, this.info, expr.arg(0), Int.get(r.start + 2L), Int.get(r.length - 1L));
        }
        if (Function._UTIL_REPLICATE.is(expr) && (args = expr.args())[1] instanceof Int && args[0].seqType().zeroOrOne()) {
            args[1] = Int.get(((Int)args[1]).itr() - 1L);
            return cc.function(Function._UTIL_REPLICATE, this.info, args);
        }
        if (Function._FILE_READ_TEXT_LINES.is(expr)) {
            return FileReadTextLines.opt(this, 1L, Long.MAX_VALUE, cc);
        }
        if (expr instanceof List && (first = (args = expr.args())[0]).seqType().oneOrMore()) {
            args[0] = cc.function(Function.TAIL, this.info, first);
            return List.get(cc, this.info, args);
        }
        this.exprType.assign(st.union(Occ.ZERO), size - 1L);
        this.data(expr.data());
        return this;
    }

    @Override
    public boolean ddo() {
        return this.exprs[0].ddo();
    }
}

