/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Range;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public class FnSum
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Expr expr = this.exprs[0];
        if (expr instanceof RangeSeq || expr instanceof Range) {
            Item item = this.range(expr.value(qc), false);
            if (item != null) {
                return item;
            }
        } else {
            Item item;
            if (expr instanceof SingletonSeq && (item = this.singleton((SingletonSeq)expr, false)) != null) {
                return item;
            }
            Iter iter = this.exprs[0].atomIter(qc, this.info);
            Item item2 = iter.next();
            if (item2 != null) {
                return this.sum(iter, item2, false, qc);
            }
        }
        return this.exprs.length == 2 ? this.exprs[1].atomItem(qc, this.info) : Int.ZERO;
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        SeqType st2;
        Item item;
        Expr expr1 = this.exprs[0];
        if (expr1 instanceof RangeSeq) {
            return this.range((Value)expr1, false);
        }
        if (expr1 instanceof SingletonSeq && (item = this.singleton((SingletonSeq)expr1, false)) != null) {
            return item;
        }
        Expr expr2 = this.exprs.length == 2 ? this.exprs[1] : null;
        SeqType st1 = expr1.seqType();
        SeqType seqType = st2 = expr2 != null ? expr2.seqType() : null;
        if (st1.zero()) {
            if (!expr1.has(Flag.NDT)) {
                if (expr2 == null) {
                    return Int.ZERO;
                }
                if (expr2 == Empty.VALUE) {
                    return expr1;
                }
                if (st2.instanceOf(SeqType.INTEGER_O)) {
                    return expr2;
                }
            }
        } else if (st1.oneOrMore() && !st1.mayBeArray()) {
            Type type1 = st1.type;
            if (type1.isNumber()) {
                this.exprType.assign(type1.seqType());
            } else if (type1.isUntyped()) {
                this.exprType.assign(SeqType.DOUBLE_O);
            }
        } else if (st2 != null && !st2.zero() && !st2.mayBeArray()) {
            Occ occ = st2.oneOrMore() ? Occ.EXACTLY_ONE : Occ.ZERO_OR_ONE;
            this.exprType.assign(Calc.PLUS.type(st1.type, st2.type), occ);
        }
        return this;
    }

    @Override
    protected final void simplifyArgs(CompileContext cc) {
    }

    protected final Item range(Value value, boolean avg) throws QueryException {
        long l;
        BigInteger be;
        if (value.isEmpty()) {
            return null;
        }
        long min = value.itemAt(0L).itr(this.info);
        long max = value.itemAt(value.size() - 1L).itr(this.info);
        if (avg) {
            BigDecimal bs = BigDecimal.valueOf(min);
            BigDecimal be2 = BigDecimal.valueOf(max);
            return Dec.get(bs.add(be2).divide(Dec.BD_2, MathContext.DECIMAL64));
        }
        if (min > max) {
            long t = max;
            max = min;
            min = t;
        }
        if (max < 3037000500L) {
            return Int.get((min + max) * (max - min + 1L) / 2L);
        }
        BigInteger bs = BigInteger.valueOf(min);
        BigInteger bi = bs.add(be = BigInteger.valueOf(max)).multiply(be.subtract(bs).add(BigInteger.ONE)).divide(BigInteger.valueOf(2L));
        if (bi.equals(BigInteger.valueOf(l = bi.longValue()))) {
            return Int.get(l);
        }
        throw QueryError.RANGE_X.get(this.info, bi);
    }

    protected final Item singleton(SingletonSeq seq, boolean avg) throws QueryException {
        if (seq.singleItem()) {
            Item item = seq.itemAt(0L);
            if (item.type.isUntyped()) {
                item = Dbl.get(item.dbl(this.info));
            }
            if (item.type.isNumber()) {
                return avg ? item : Calc.MULT.eval(item, Int.get(seq.size()), this.info);
            }
        }
        return null;
    }

    final Item sum(Iter iter, Item item, boolean avg, QueryContext qc) throws QueryException {
        Item it;
        boolean ymd;
        Item result = item.type.isUntyped() ? Dbl.get(item.dbl(this.info)) : item;
        boolean num = result instanceof ANum;
        boolean dtd = result.type == AtomType.DAY_TIME_DURATION;
        boolean bl = ymd = result.type == AtomType.YEAR_MONTH_DURATION;
        if (!(num || dtd || ymd)) {
            throw QueryError.SUM_X_X.get(this.info, result.type, result);
        }
        int c = 1;
        while ((it = qc.next(iter)) != null) {
            Type type = it.type;
            AtomType tp = null;
            if (type.isNumberOrUntyped()) {
                if (!num) {
                    tp = AtomType.DURATION;
                }
            } else if (num) {
                tp = AtomType.NUMERIC;
            } else if (dtd && type != AtomType.DAY_TIME_DURATION || ymd && type != AtomType.YEAR_MONTH_DURATION) {
                tp = AtomType.DURATION;
            }
            if (tp != null) {
                throw QueryError.CMP_X_X_X.get(this.info, tp, type, it);
            }
            result = Calc.PLUS.eval(result, it, this.info);
            ++c;
        }
        return avg ? Calc.DIV.eval(result, Int.get(c), this.info) : result;
    }
}

