/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Range;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.Value;
import org.basex.query.value.item.ADate;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.seq.SingletonSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public class FnMin
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        return this.minmax(CmpV.OpV.GT, qc);
    }

    final Item minmax(CmpV.OpV cmp, QueryContext qc) throws QueryException {
        Item item2;
        Collation coll = this.toCollation(1, qc);
        Expr expr = this.exprs[0];
        Item item1 = this.value(cmp);
        if (item1 != null) {
            return item1;
        }
        if (expr instanceof Range) {
            Value value = expr.value(qc);
            return value.isEmpty() ? Empty.VALUE : value.itemAt(cmp == CmpV.OpV.GT ? 0L : value.size() - 1L);
        }
        Iter iter = expr.atomIter(qc, this.info);
        item1 = iter.next();
        if (item1 == null) {
            return Empty.VALUE;
        }
        Type type1 = item1.type;
        if (!type1.isSortable()) {
            throw QueryError.CMP_X.get(this.info, type1);
        }
        if (item1 instanceof AStr) {
            Item item22;
            while ((item22 = qc.next(iter)) != null) {
                if (!(item22 instanceof AStr)) {
                    throw QueryError.CMP_X_X_X.get(this.info, type1, item22.type, item22);
                }
                Type type2 = item22.type;
                if (cmp.eval(item1, item22, coll, this.sc, this.info)) {
                    item1 = item22;
                }
                if (type1 == type2 || item1.type != AtomType.ANY_URI) continue;
                item1 = AtomType.STRING.cast(item1, qc, this.sc, this.info);
            }
            return item1;
        }
        if (type1 == AtomType.BOOLEAN || item1 instanceof ADate || item1 instanceof Dur || item1 instanceof Bin) {
            Item item;
            while ((item = qc.next(iter)) != null) {
                if (type1 != item.type) {
                    throw QueryError.CMP_X_X_X.get(this.info, type1, item.type, item);
                }
                if (!cmp.eval(item1, item, coll, this.sc, this.info)) continue;
                item1 = item;
            }
            return item1;
        }
        if (type1.isUntyped()) {
            item1 = AtomType.DOUBLE.cast(item1, qc, this.sc, this.info);
        }
        while ((item2 = qc.next(iter)) != null) {
            AtomType type = this.numType(item1, item2);
            if (cmp.eval(item1, item2, coll, this.sc, this.info) || Double.isNaN(item2.dbl(this.info))) {
                item1 = item2;
            }
            if (type == null) continue;
            item1 = type.cast(item1, qc, this.sc, this.info);
        }
        return item1;
    }

    private AtomType numType(Item item1, Item item2) throws QueryException {
        Type type2 = item2.type;
        if (type2.isUntyped()) {
            return AtomType.DOUBLE;
        }
        Type type1 = item1.type;
        if (!(item2 instanceof ANum)) {
            throw QueryError.CMP_X_X_X.get(this.info, type1, type2, item2);
        }
        return type1 == type2 ? null : (type1 == AtomType.DOUBLE || type2 == AtomType.DOUBLE ? AtomType.DOUBLE : (type1 == AtomType.FLOAT || type2 == AtomType.FLOAT ? AtomType.FLOAT : null));
    }

    private Item value(CmpV.OpV cmp) {
        Expr expr = this.exprs[0];
        if (expr instanceof Value && this.exprs.length < 2) {
            Type type;
            Item item = null;
            Value value = (Value)expr;
            long size = value.size();
            if (value instanceof RangeSeq) {
                RangeSeq seq = (RangeSeq)value;
                item = seq.itemAt(cmp == CmpV.OpV.GT ^ seq.asc ? size - 1L : 0L);
            } else if (value instanceof SingletonSeq && ((SingletonSeq)value).singleItem()) {
                item = value.itemAt(0L);
            } else if (value.isItem()) {
                item = (Item)value;
            }
            if (item != null && ((type = item.seqType().type).isNumber() || type.instanceOf(AtomType.STRING))) {
                return item;
            }
        }
        return null;
    }

    @Override
    protected void simplifyArgs(CompileContext cc) throws QueryException {
        if (this.exprs.length > 1) {
            this.exprs[1] = this.exprs[1].simplifyFor(CompileContext.Simplify.STRING, cc);
        }
    }

    @Override
    protected Expr opt(CompileContext cc) {
        return this.opt(CmpV.OpV.GT);
    }

    final Expr opt(CmpV.OpV cmp) {
        Expr expr = this.optFirst();
        if (expr != this) {
            return expr;
        }
        expr = this.exprs[0];
        SeqType st = expr.seqType();
        Type type = st.type;
        if (type.isSortable()) {
            if (type.isUntyped()) {
                type = AtomType.DOUBLE;
            } else if (st.one() && this.exprs.length < 2) {
                return expr;
            }
            this.exprType.assign(type);
            Item item = this.value(cmp);
            if (item != null) {
                return item;
            }
        }
        return this;
    }
}

