/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.func.Function;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.value.item.Int;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;

public final class FnCount
extends StandardFunc {
    @Override
    public Int item(QueryContext qc, InputInfo ii) throws QueryException {
        Iter iter = this.exprs[0].iter(qc);
        long size = iter.size();
        if (size == -1L) {
            do {
                ++size;
            } while (qc.next(iter) != null);
        }
        return Int.get(size);
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        Expr expr = this.exprs[0];
        long size = expr.size();
        if (size >= 0L && !expr.has(Flag.NDT)) {
            return Int.get(size);
        }
        if (Function._MAP_KEYS.is(expr)) {
            return cc.function(Function._MAP_SIZE, this.info, expr.args());
        }
        if (Function.STRING_TO_CODEPOINTS.is(expr) || Function._UTIL_CHARS.is(expr)) {
            return cc.function(Function.STRING_LENGTH, this.info, expr.args());
        }
        Expr arg = FnCount.simplify(expr, cc);
        return arg != expr ? cc.function(Function.COUNT, this.info, arg) : this;
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        if (mode == CompileContext.Simplify.EBV) {
            Expr expr = this.exprs[0];
            return cc.simplify(this, expr.seqType().type instanceof NodeType ? expr : cc.function(Function.EXISTS, this.info, this.exprs));
        }
        return this;
    }

    public static Expr simplify(Expr expr, CompileContext cc) throws QueryException {
        Expr flwor;
        if (expr instanceof Filter) {
            return ((Filter)expr).simplifyCount(cc);
        }
        if (Function.REVERSE.is(expr) || Function.SORT.is(expr)) {
            return expr.arg(0);
        }
        if (expr instanceof GFLWOR && (flwor = ((GFLWOR)expr).removeOrderBy(cc)) != null) {
            return flwor;
        }
        return expr;
    }
}

