/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.func.fn.RegEx;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class FnAnalyzeString
extends RegEx {
    private static final QNm Q_ANALYZE = new QNm(QueryText.FN_PREFIX, "analyze-string-result", QueryText.FN_URI);
    private static final QNm Q_MATCH = new QNm(QueryText.FN_PREFIX, "match", QueryText.FN_URI);
    private static final QNm Q_NONMATCH = new QNm(QueryText.FN_PREFIX, "non-match", QueryText.FN_URI);
    private static final QNm Q_MGROUP = new QNm(QueryText.FN_PREFIX, "group", QueryText.FN_URI);
    private static final String NR = "nr";

    @Override
    public FElem item(QueryContext qc, InputInfo ii) throws QueryException {
        byte[] value = this.toZeroToken(this.exprs[0], qc);
        Pattern pattern = this.pattern(this.exprs[1], this.exprs.length == 3 ? this.exprs[2] : null, qc, true);
        String string = Token.string(value);
        Matcher matcher = pattern.matcher(string);
        FElem root = new FElem(Q_ANALYZE).declareNS();
        int start = 0;
        while (matcher.find()) {
            if (start != matcher.start()) {
                FnAnalyzeString.nonmatch(string.substring(start, matcher.start()), root);
            }
            FnAnalyzeString.match(matcher, string, root, 0);
            start = matcher.end();
        }
        if (start != string.length()) {
            FnAnalyzeString.nonmatch(string.substring(start), root);
        }
        return root;
    }

    private static int[] match(Matcher matcher, String string, FElem parent, int group) {
        FElem nd = new FElem(group == 0 ? Q_MATCH : Q_MGROUP);
        if (group > 0) {
            nd.add(NR, Token.token(group));
        }
        int start = matcher.start(group);
        int end = matcher.end(group);
        int gc = matcher.groupCount();
        int[] pos = new int[]{group + 1, start};
        while (pos[0] <= gc && matcher.end(pos[0]) <= end) {
            int st = matcher.start(pos[0]);
            if (st >= 0) {
                if (pos[1] < st) {
                    nd.add(string.substring(pos[1], st));
                }
                pos = FnAnalyzeString.match(matcher, string, nd, pos[0]);
                continue;
            }
            pos[0] = pos[0] + 1;
        }
        if (pos[1] < end) {
            nd.add(string.substring(pos[1], end));
            pos[1] = end;
        }
        parent.add(nd);
        return pos;
    }

    private static void nonmatch(String text, FElem par) {
        par.add(new FElem(Q_NONMATCH).add(text));
    }
}

