/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.basex.io.out.PrintOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileFn;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.util.Prop;
import org.basex.util.Token;

public class FileWriteTextLines
extends FileFn {
    private static final byte[] NL = Token.token(Prop.NL);

    @Override
    public Item item(QueryContext qc) throws IOException, QueryException {
        this.write(false, qc);
        return Empty.VALUE;
    }

    final synchronized void write(boolean append, QueryContext qc) throws QueryException, IOException {
        Path path = this.checkParentDir(this.toPath(0, qc));
        String encoding = this.toEncodingOrNull(2, QueryError.FILE_UNKNOWN_ENCODING_X, qc);
        Charset cs = encoding == null || encoding == "UTF-8" ? null : Charset.forName(encoding);
        try (PrintOutput out = PrintOutput.get(new FileOutputStream(path.toFile(), append));){
            Item item;
            Iter iter = this.exprs[1].iter(qc);
            while ((item = iter.next()) != null) {
                if (!item.type.isStringOrUntyped()) {
                    throw QueryError.typeError(item, AtomType.STRING, this.info);
                }
                byte[] s = item.string(this.info);
                out.write(cs == null ? s : Token.string(s).getBytes(cs));
                out.write(cs == null ? NL : Prop.NL.getBytes(cs));
            }
        }
    }
}

