/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.file;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Path;
import org.basex.io.in.BufferInput;
import org.basex.io.out.BufferOutput;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.file.FileFn;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;

public class FileWriteBinary
extends FileFn {
    @Override
    public Item item(QueryContext qc) throws IOException, QueryException {
        this.write(false, qc);
        return Empty.VALUE;
    }

    final synchronized void write(boolean append, QueryContext qc) throws QueryException, IOException {
        block39: {
            Path path = this.checkParentDir(this.toPath(0, qc));
            Bin bin = this.toBin(this.exprs[1], qc);
            if (this.exprs.length == 2) {
                try (BufferOutput out = new BufferOutput(new FileOutputStream(path.toFile(), append));
                     BufferInput in = bin.input(this.info);){
                    int b;
                    while ((b = in.read()) != -1) {
                        out.write(b);
                    }
                    break block39;
                }
            }
            long off = this.toLong(this.exprs[2], qc);
            try (RandomAccessFile raf = new RandomAccessFile(path.toFile(), "rw");){
                long dlen = raf.length();
                if (off < 0L || off > dlen) {
                    throw QueryError.FILE_OUT_OF_RANGE_X_X.get(this.info, off, dlen);
                }
                raf.seek(off);
                raf.write(bin.binary(this.info));
            }
        }
    }
}

