/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.db.DbList;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;
import org.basex.util.http.MediaType;
import org.basex.util.list.IntList;

public final class DbDir
extends DbList {
    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        return this.resources(qc).iter(qc);
    }

    @Override
    public Value value(QueryContext qc) throws QueryException {
        return this.resources(qc);
    }

    private Value resources(QueryContext qc) throws QueryException {
        Data data = this.checkData(qc);
        byte[] path = this.toToken(this.exprs[1], qc);
        String root = MetaData.normPath(Token.string(path));
        if (root == null) {
            throw QueryError.DB_PATH_X.get(this.info, new Object[]{path});
        }
        if (!root.isEmpty() && !Strings.endsWith(root, '/')) {
            root = root + '/';
        }
        path = Token.token(root);
        ValueBuilder vb = new ValueBuilder(qc);
        TokenSet map = new TokenSet();
        IntList docs = data.resources.docs(root, false);
        int ds = docs.size();
        for (int d = 0; d < ds; ++d) {
            boolean dir;
            byte[] np = data.text(docs.get(d), true);
            int i = Token.indexOf(np = Token.substring(np, path.length, np.length), Token.SLASH);
            boolean bl = dir = i >= 0;
            if (dir) {
                np = Token.substring(np, 0, i);
            }
            if (map.contains(np)) continue;
            map.put(np);
            vb.add(dir ? DbDir.dir(np, data.meta.time) : DbDir.resource(np, false, MediaType.APPLICATION_XML, data.meta.time, null));
        }
        IOFile file = data.meta.binary(Token.string(path));
        if (file != null) {
            for (IOFile io : file.children()) {
                byte[] np = Token.token(io.name());
                if (map.contains(np)) continue;
                map.put(np);
                vb.add(io.isDir() ? DbDir.dir(np, io.timeStamp()) : DbDir.resource(np, true, MediaType.get(io.path()), io.timeStamp(), io.length()));
            }
        }
        return vb.value(this);
    }
}

