/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.db;

import org.basex.core.Databases;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.StandardFunc;
import org.basex.query.up.primitives.name.DBAlter;
import org.basex.query.up.primitives.name.DBCopy;
import org.basex.query.util.ASTVisitor;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public class DbCopy
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        this.copy(qc, true);
        return Empty.VALUE;
    }

    final void copy(QueryContext qc, boolean keep) throws QueryException {
        String name = Token.string(this.toToken(this.exprs[0], qc));
        String newname = Token.string(this.toToken(this.exprs[1], qc));
        if (!Databases.validName(name)) {
            throw QueryError.DB_NAME_X.get(this.info, name);
        }
        if (!Databases.validName(newname)) {
            throw QueryError.DB_NAME_X.get(this.info, newname);
        }
        if (!qc.context.soptions.dbExists(name)) {
            throw QueryError.DB_OPEN1_X.get(this.info, name);
        }
        if (name.equals(newname)) {
            throw QueryError.DB_CONFLICT4_X.get(this.info, name, newname);
        }
        qc.updates().add(keep ? new DBCopy(name, newname, qc, this.info) : new DBAlter(name, newname, qc, this.info), qc);
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        return this.dataLock(visitor, 0) && this.dataLock(visitor, 1) && super.accept(visitor);
    }
}

