/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.crypto;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.value.item.B64;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.util.Base64;
import org.basex.util.InputInfo;
import org.basex.util.Token;

final class Encryption {
    private static final HashMap<String, String> TRANSFORMATIONS = new HashMap();
    private static final HashMap<String, Integer> IVLENGTHS = new HashMap();
    private static final String SYMMETRIC = "symmetric";
    private static final String BASE64 = "base64";
    private static final String HEX = "hex";
    private final InputInfo info;

    Encryption(InputInfo info) {
        this.info = info;
    }

    Item encryption(byte[] data, String type, byte[] key, String algorithm, boolean encrypt) throws QueryException {
        if (!type.equals(SYMMETRIC)) {
            throw QueryError.CX_ENCTYP_X.get(this.info, type);
        }
        String transformation = TRANSFORMATIONS.get(algorithm);
        if (transformation == null) {
            throw QueryError.CX_INVALGO_X.get(this.info, algorithm);
        }
        int ivl = IVLENGTHS.get(algorithm);
        try {
            SecretKeySpec kspec = new SecretKeySpec(key, algorithm);
            Cipher cipher = Cipher.getInstance(transformation);
            return encrypt ? Encryption.encrypt(data, kspec, cipher, ivl) : Encryption.decrypt(data, kspec, cipher, ivl);
        }
        catch (NoSuchPaddingException ex) {
            throw QueryError.CX_NOPAD_X.get(this.info, ex);
        }
        catch (BadPaddingException ex) {
            throw QueryError.CX_BADPAD_X.get(this.info, ex);
        }
        catch (IllegalArgumentException | InvalidKeyException ex) {
            throw QueryError.CX_KEYINV_X.get(this.info, ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw QueryError.CX_ILLBLO_X.get(this.info, ex);
        }
        catch (GeneralSecurityException ex) {
            throw QueryError.CX_INVALGO_X.get(this.info, ex);
        }
    }

    private static B64 encrypt(byte[] data, Key kspec, Cipher cipher, int ivl) throws GeneralSecurityException {
        byte[] iv = new byte[ivl];
        SecureRandom.getInstance("SHA1PRNG").nextBytes(iv);
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        cipher.init(1, kspec, ivspec);
        byte[] ciph = cipher.doFinal(data);
        return B64.get(Token.concat(iv, ciph));
    }

    private static Str decrypt(byte[] data, Key kspec, Cipher cipher, int ivl) throws GeneralSecurityException {
        byte[] iv = Token.substring(data, 0, ivl);
        byte[] input = Token.substring(data, ivl, data.length);
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        cipher.init(2, kspec, ivspec);
        byte[] ciph = cipher.doFinal(input);
        return Str.get(ciph);
    }

    Item hmac(byte[] data, byte[] key, String algorithm, String encoding) throws QueryException {
        boolean b64;
        boolean bl = b64 = encoding == null || encoding.equals(BASE64);
        if (!b64 && !encoding.equals(HEX)) {
            throw QueryError.CX_ENC_X.get(this.info, encoding);
        }
        try {
            SecretKeySpec kspec = new SecretKeySpec(key, algorithm);
            Mac mac = Mac.getInstance("hmac" + algorithm);
            mac.init(kspec);
            byte[] hash = mac.doFinal(data);
            return Str.get(b64 ? Base64.encode(hash) : Token.hex(hash, true));
        }
        catch (NoSuchAlgorithmException ex) {
            throw QueryError.CX_INVHASH_X.get(this.info, algorithm);
        }
        catch (IllegalArgumentException | InvalidKeyException ex) {
            throw QueryError.CX_KEYINV_X.get(this.info, ex);
        }
    }

    static {
        TRANSFORMATIONS.put("DES", "DES/CBC/PKCS5Padding");
        TRANSFORMATIONS.put("AES", "AES/CBC/PKCS5Padding");
        IVLENGTHS.put("DES", 8);
        IVLENGTHS.put("AES", 16);
    }
}

