/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.array;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.func.array.ArrayFn;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class ArraySubarray
extends ArrayFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        XQArray array = this.toArray(this.exprs[0], qc);
        long n = array.arraySize();
        long from = this.toLong(this.exprs[1], qc) - 1L;
        if (from < 0L || from > n) {
            throw QueryError.ARRAYBOUNDS_X_X.get(this.info, from + 1L, n + 1L);
        }
        if (this.exprs.length == 2) {
            return array.subArray(from, n - from, qc);
        }
        long len = this.toLong(this.exprs[2], qc);
        if (len < 0L) {
            throw QueryError.ARRAYNEG_X.get(this.info, len);
        }
        if (from + len > n) {
            throw QueryError.ARRAYBOUNDS_X_X.get(this.info, from + 1L + len, n + 1L);
        }
        return array.subArray(from, len, qc);
    }

    @Override
    protected Expr opt(CompileContext cc) {
        Type type = this.exprs[0].seqType().type;
        if (type instanceof ArrayType) {
            this.exprType.assign(type);
        }
        return this;
    }
}

